package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class RegisterAccountResponse(
    registerAccountStatus: zio.aws.iotfleetwise.model.RegistrationStatus,
    timestreamResources: zio.aws.iotfleetwise.model.TimestreamResources,
    iamResources: zio.aws.iotfleetwise.model.IamResources,
    creationTime: Timestamp,
    lastModificationTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountResponse = {
    import RegisterAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountResponse
      .builder()
      .registerAccountStatus(registerAccountStatus.unwrap)
      .timestreamResources(timestreamResources.buildAwsValue())
      .iamResources(iamResources.buildAwsValue())
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModificationTime(Timestamp.unwrap(lastModificationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.RegisterAccountResponse.ReadOnly =
    zio.aws.iotfleetwise.model.RegisterAccountResponse.wrap(buildAwsValue())
}
object RegisterAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.RegisterAccountResponse =
      zio.aws.iotfleetwise.model.RegisterAccountResponse(
        registerAccountStatus,
        timestreamResources.asEditable,
        iamResources.asEditable,
        creationTime,
        lastModificationTime
      )
    def registerAccountStatus: zio.aws.iotfleetwise.model.RegistrationStatus
    def timestreamResources
        : zio.aws.iotfleetwise.model.TimestreamResources.ReadOnly
    def iamResources: zio.aws.iotfleetwise.model.IamResources.ReadOnly
    def creationTime: Timestamp
    def lastModificationTime: Timestamp
    def getRegisterAccountStatus
        : ZIO[Any, Nothing, zio.aws.iotfleetwise.model.RegistrationStatus] =
      ZIO.succeed(registerAccountStatus)
    def getTimestreamResources: ZIO[
      Any,
      Nothing,
      zio.aws.iotfleetwise.model.TimestreamResources.ReadOnly
    ] = ZIO.succeed(timestreamResources)
    def getIamResources
        : ZIO[Any, Nothing, zio.aws.iotfleetwise.model.IamResources.ReadOnly] =
      ZIO.succeed(iamResources)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModificationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountResponse
  ) extends zio.aws.iotfleetwise.model.RegisterAccountResponse.ReadOnly {
    override val registerAccountStatus
        : zio.aws.iotfleetwise.model.RegistrationStatus =
      zio.aws.iotfleetwise.model.RegistrationStatus
        .wrap(impl.registerAccountStatus())
    override val timestreamResources
        : zio.aws.iotfleetwise.model.TimestreamResources.ReadOnly =
      zio.aws.iotfleetwise.model.TimestreamResources
        .wrap(impl.timestreamResources())
    override val iamResources
        : zio.aws.iotfleetwise.model.IamResources.ReadOnly =
      zio.aws.iotfleetwise.model.IamResources.wrap(impl.iamResources())
    override val creationTime: Timestamp =
      zio.aws.iotfleetwise.model.primitives.Timestamp(impl.creationTime())
    override val lastModificationTime: Timestamp =
      zio.aws.iotfleetwise.model.primitives
        .Timestamp(impl.lastModificationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountResponse
  ): zio.aws.iotfleetwise.model.RegisterAccountResponse.ReadOnly = new Wrapper(
    impl
  )
}
