package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{
  NodePath,
  Description,
  CampaignName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateCampaignRequest(
    name: CampaignName,
    description: Optional[Description] = Optional.Absent,
    dataExtraDimensions: Optional[Iterable[NodePath]] = Optional.Absent,
    action: zio.aws.iotfleetwise.model.UpdateCampaignAction
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignRequest = {
    import UpdateCampaignRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignRequest
      .builder()
      .name(CampaignName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        dataExtraDimensions.map(value =>
          value.map { item =>
            NodePath.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dataExtraDimensions)
      .action(action.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.UpdateCampaignRequest.ReadOnly =
    zio.aws.iotfleetwise.model.UpdateCampaignRequest.wrap(buildAwsValue())
}
object UpdateCampaignRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.UpdateCampaignRequest =
      zio.aws.iotfleetwise.model.UpdateCampaignRequest(
        name,
        description.map(value => value),
        dataExtraDimensions.map(value => value),
        action
      )
    def name: CampaignName
    def description: Optional[Description]
    def dataExtraDimensions: Optional[List[NodePath]]
    def action: zio.aws.iotfleetwise.model.UpdateCampaignAction
    def getName: ZIO[Any, Nothing, CampaignName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDataExtraDimensions: ZIO[Any, AwsError, List[NodePath]] =
      AwsError.unwrapOptionField("dataExtraDimensions", dataExtraDimensions)
    def getAction
        : ZIO[Any, Nothing, zio.aws.iotfleetwise.model.UpdateCampaignAction] =
      ZIO.succeed(action)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignRequest
  ) extends zio.aws.iotfleetwise.model.UpdateCampaignRequest.ReadOnly {
    override val name: CampaignName =
      zio.aws.iotfleetwise.model.primitives.CampaignName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
    override val dataExtraDimensions: Optional[List[NodePath]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataExtraDimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.primitives.NodePath(item)
          }.toList
        )
    override val action: zio.aws.iotfleetwise.model.UpdateCampaignAction =
      zio.aws.iotfleetwise.model.UpdateCampaignAction.wrap(impl.action())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignRequest
  ): zio.aws.iotfleetwise.model.UpdateCampaignRequest.ReadOnly = new Wrapper(
    impl
  )
}
