package zio.aws.iotfleetwise.model
import scala.jdk.CollectionConverters._
sealed trait SpoolingMode {
  def unwrap: software.amazon.awssdk.services.iotfleetwise.model.SpoolingMode
}
object SpoolingMode {
  def wrap(
      value: software.amazon.awssdk.services.iotfleetwise.model.SpoolingMode
  ): zio.aws.iotfleetwise.model.SpoolingMode = value match {
    case software.amazon.awssdk.services.iotfleetwise.model.SpoolingMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotfleetwise.model.SpoolingMode.OFF =>
      val r = OFF
      r
    case software.amazon.awssdk.services.iotfleetwise.model.SpoolingMode.TO_DISK =>
      val r = TO_DISK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotfleetwise.model.SpoolingMode {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.SpoolingMode =
      software.amazon.awssdk.services.iotfleetwise.model.SpoolingMode.UNKNOWN_TO_SDK_VERSION
  }
  case object OFF extends zio.aws.iotfleetwise.model.SpoolingMode {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.SpoolingMode =
      software.amazon.awssdk.services.iotfleetwise.model.SpoolingMode.OFF
  }
  case object TO_DISK extends zio.aws.iotfleetwise.model.SpoolingMode {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.SpoolingMode =
      software.amazon.awssdk.services.iotfleetwise.model.SpoolingMode.TO_DISK
  }
}
