package zio.aws.iotfleethub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotfleethub.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListApplicationsResponse(
    applicationSummaries: Optional[
      Iterable[zio.aws.iotfleethub.model.ApplicationSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleethub.model.ListApplicationsResponse = {
    import ListApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleethub.model.ListApplicationsResponse
      .builder()
      .optionallyWith(
        applicationSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applicationSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotfleethub.model.ListApplicationsResponse.ReadOnly =
    zio.aws.iotfleethub.model.ListApplicationsResponse.wrap(buildAwsValue())
}
object ListApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleethub.model.ListApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleethub.model.ListApplicationsResponse =
      zio.aws.iotfleethub.model.ListApplicationsResponse(
        applicationSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def applicationSummaries
        : Optional[List[zio.aws.iotfleethub.model.ApplicationSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getApplicationSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotfleethub.model.ApplicationSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("applicationSummaries", applicationSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleethub.model.ListApplicationsResponse
  ) extends zio.aws.iotfleethub.model.ListApplicationsResponse.ReadOnly {
    override val applicationSummaries: Optional[
      List[zio.aws.iotfleethub.model.ApplicationSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotfleethub.model.ApplicationSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleethub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleethub.model.ListApplicationsResponse
  ): zio.aws.iotfleethub.model.ListApplicationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
