package zio.aws.iotfleethub.model
import scala.jdk.CollectionConverters._
sealed trait ApplicationState {
  def unwrap: software.amazon.awssdk.services.iotfleethub.model.ApplicationState
}
object ApplicationState {
  def wrap(
      value: software.amazon.awssdk.services.iotfleethub.model.ApplicationState
  ): zio.aws.iotfleethub.model.ApplicationState = value match {
    case software.amazon.awssdk.services.iotfleethub.model.ApplicationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotfleethub.model.ApplicationState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.iotfleethub.model.ApplicationState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.iotfleethub.model.ApplicationState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.iotfleethub.model.ApplicationState.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.iotfleethub.model.ApplicationState.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotfleethub.model.ApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.iotfleethub.model.ApplicationState =
      software.amazon.awssdk.services.iotfleethub.model.ApplicationState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.iotfleethub.model.ApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.iotfleethub.model.ApplicationState =
      software.amazon.awssdk.services.iotfleethub.model.ApplicationState.CREATING
  }
  case object DELETING extends zio.aws.iotfleethub.model.ApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.iotfleethub.model.ApplicationState =
      software.amazon.awssdk.services.iotfleethub.model.ApplicationState.DELETING
  }
  case object ACTIVE extends zio.aws.iotfleethub.model.ApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.iotfleethub.model.ApplicationState =
      software.amazon.awssdk.services.iotfleethub.model.ApplicationState.ACTIVE
  }
  case object CREATE_FAILED extends zio.aws.iotfleethub.model.ApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.iotfleethub.model.ApplicationState =
      software.amazon.awssdk.services.iotfleethub.model.ApplicationState.CREATE_FAILED
  }
  case object DELETE_FAILED extends zio.aws.iotfleethub.model.ApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.iotfleethub.model.ApplicationState =
      software.amazon.awssdk.services.iotfleethub.model.ApplicationState.DELETE_FAILED
  }
}
