package zio.aws.iotfleethub.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotfleethub.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleethub.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleethub.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleethub.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.iotfleethub.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleethub.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleethub.model.ListTagsForResourceRequest =
      zio.aws.iotfleethub.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleethub.model.ListTagsForResourceRequest
  ) extends zio.aws.iotfleethub.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.iotfleethub.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleethub.model.ListTagsForResourceRequest
  ): zio.aws.iotfleethub.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
