package zio.aws.iotfleethub.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotfleethub.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class DescribeApplicationRequest(applicationId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleethub.model.DescribeApplicationRequest = {
    import DescribeApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleethub.model.DescribeApplicationRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleethub.model.DescribeApplicationRequest.ReadOnly =
    zio.aws.iotfleethub.model.DescribeApplicationRequest.wrap(buildAwsValue())
}
object DescribeApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleethub.model.DescribeApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleethub.model.DescribeApplicationRequest =
      zio.aws.iotfleethub.model.DescribeApplicationRequest(applicationId)
    def applicationId: Id
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleethub.model.DescribeApplicationRequest
  ) extends zio.aws.iotfleethub.model.DescribeApplicationRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.iotfleethub.model.primitives.Id(impl.applicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleethub.model.DescribeApplicationRequest
  ): zio.aws.iotfleethub.model.DescribeApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
