package zio.aws.iotfleethub
import zio.aws.iotfleethub.model.TagResourceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.iotfleethub.model.{
  UpdateApplicationRequest,
  DeleteApplicationRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  DescribeApplicationRequest,
  UntagResourceRequest,
  ListApplicationsRequest,
  TagResourceRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.iotfleethub.IoTFleetHubAsyncClient
object IoTFleetHubMock extends Mock[IoTFleetHub] {
  object DeleteApplication
      extends Effect[
        DeleteApplicationRequest,
        AwsError,
        zio.aws.iotfleethub.model.DeleteApplicationResponse.ReadOnly
      ]
  object DescribeApplication
      extends Effect[
        DescribeApplicationRequest,
        AwsError,
        zio.aws.iotfleethub.model.DescribeApplicationResponse.ReadOnly
      ]
  object CreateApplication
      extends Effect[
        CreateApplicationRequest,
        AwsError,
        zio.aws.iotfleethub.model.CreateApplicationResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.iotfleethub.model.UntagResourceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.iotfleethub.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, ReadOnly]
  object ListApplications
      extends Stream[
        ListApplicationsRequest,
        AwsError,
        zio.aws.iotfleethub.model.ApplicationSummary.ReadOnly
      ]
  object ListApplicationsPaginated
      extends Effect[
        ListApplicationsRequest,
        AwsError,
        zio.aws.iotfleethub.model.ListApplicationsResponse.ReadOnly
      ]
  object UpdateApplication
      extends Effect[
        UpdateApplicationRequest,
        AwsError,
        zio.aws.iotfleethub.model.UpdateApplicationResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, IoTFleetHub] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, IoTFleetHub] { rts =>
        zio.ZIO.succeed {
          new IoTFleetHub {
            val api: IoTFleetHubAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): IoTFleetHub = this
            def deleteApplication(request: DeleteApplicationRequest): IO[
              AwsError,
              zio.aws.iotfleethub.model.DeleteApplicationResponse.ReadOnly
            ] = proxy(DeleteApplication, request)
            def describeApplication(request: DescribeApplicationRequest): IO[
              AwsError,
              zio.aws.iotfleethub.model.DescribeApplicationResponse.ReadOnly
            ] = proxy(DescribeApplication, request)
            def createApplication(request: CreateApplicationRequest): IO[
              AwsError,
              zio.aws.iotfleethub.model.CreateApplicationResponse.ReadOnly
            ] = proxy(CreateApplication, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.iotfleethub.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.iotfleethub.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, ReadOnly] = proxy(TagResource, request)
            def listApplications(request: ListApplicationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotfleethub.model.ApplicationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApplications, request)
                }
                .getOrThrowFiberFailure()
            }
            def listApplicationsPaginated(request: ListApplicationsRequest): IO[
              AwsError,
              zio.aws.iotfleethub.model.ListApplicationsResponse.ReadOnly
            ] = proxy(ListApplicationsPaginated, request)
            def updateApplication(request: UpdateApplicationRequest): IO[
              AwsError,
              zio.aws.iotfleethub.model.UpdateApplicationResponse.ReadOnly
            ] = proxy(UpdateApplication, request)
          }
        }
      }
    }
  }
}
