package zio.aws.iotfleethub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotfleethub.model.primitives.{
  ClientRequestToken,
  TagValue,
  Arn,
  Description,
  Name,
  TagKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateApplicationRequest(
    applicationName: Name,
    applicationDescription: Optional[Description] = Optional.Absent,
    clientToken: Optional[ClientRequestToken] = Optional.Absent,
    roleArn: Arn,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleethub.model.CreateApplicationRequest = {
    import CreateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleethub.model.CreateApplicationRequest
      .builder()
      .applicationName(Name.unwrap(applicationName): java.lang.String)
      .optionallyWith(
        applicationDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.applicationDescription)
      .optionallyWith(
        clientToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iotfleethub.model.CreateApplicationRequest.ReadOnly =
    zio.aws.iotfleethub.model.CreateApplicationRequest.wrap(buildAwsValue())
}
object CreateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleethub.model.CreateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleethub.model.CreateApplicationRequest =
      zio.aws.iotfleethub.model.CreateApplicationRequest(
        applicationName,
        applicationDescription.map(value => value),
        clientToken.map(value => value),
        roleArn,
        tags.map(value => value)
      )
    def applicationName: Name
    def applicationDescription: Optional[Description]
    def clientToken: Optional[ClientRequestToken]
    def roleArn: Arn
    def tags: Optional[Map[TagKey, TagValue]]
    def getApplicationName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(applicationName)
    def getApplicationDescription: ZIO[Any, AwsError, Description] = AwsError
      .unwrapOptionField("applicationDescription", applicationDescription)
    def getClientToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleethub.model.CreateApplicationRequest
  ) extends zio.aws.iotfleethub.model.CreateApplicationRequest.ReadOnly {
    override val applicationName: Name =
      zio.aws.iotfleethub.model.primitives.Name(impl.applicationName())
    override val applicationDescription: Optional[Description] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationDescription())
        .map(value => zio.aws.iotfleethub.model.primitives.Description(value))
    override val clientToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientToken())
        .map(value =>
          zio.aws.iotfleethub.model.primitives.ClientRequestToken(value)
        )
    override val roleArn: Arn =
      zio.aws.iotfleethub.model.primitives.Arn(impl.roleArn())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iotfleethub.model.primitives.TagKey(
              key
            ) -> zio.aws.iotfleethub.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleethub.model.CreateApplicationRequest
  ): zio.aws.iotfleethub.model.CreateApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
