package zio.aws.iotfleethub.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotfleethub.model.primitives.{Arn, Id}
import scala.jdk.CollectionConverters._
final case class CreateApplicationResponse(
    applicationId: Id,
    applicationArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleethub.model.CreateApplicationResponse = {
    import CreateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleethub.model.CreateApplicationResponse
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .applicationArn(Arn.unwrap(applicationArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotfleethub.model.CreateApplicationResponse.ReadOnly =
    zio.aws.iotfleethub.model.CreateApplicationResponse.wrap(buildAwsValue())
}
object CreateApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleethub.model.CreateApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleethub.model.CreateApplicationResponse =
      zio.aws.iotfleethub.model
        .CreateApplicationResponse(applicationId, applicationArn)
    def applicationId: Id
    def applicationArn: Arn
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getApplicationArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(applicationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleethub.model.CreateApplicationResponse
  ) extends zio.aws.iotfleethub.model.CreateApplicationResponse.ReadOnly {
    override val applicationId: Id =
      zio.aws.iotfleethub.model.primitives.Id(impl.applicationId())
    override val applicationArn: Arn =
      zio.aws.iotfleethub.model.primitives.Arn(impl.applicationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleethub.model.CreateApplicationResponse
  ): zio.aws.iotfleethub.model.CreateApplicationResponse.ReadOnly = new Wrapper(
    impl
  )
}
