package zio.aws.iotfleethub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotfleethub.model.primitives.{ClientRequestToken, Id}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteApplicationRequest(
    applicationId: Id,
    clientToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleethub.model.DeleteApplicationRequest = {
    import DeleteApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleethub.model.DeleteApplicationRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        clientToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.iotfleethub.model.DeleteApplicationRequest.ReadOnly =
    zio.aws.iotfleethub.model.DeleteApplicationRequest.wrap(buildAwsValue())
}
object DeleteApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleethub.model.DeleteApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleethub.model.DeleteApplicationRequest =
      zio.aws.iotfleethub.model.DeleteApplicationRequest(
        applicationId,
        clientToken.map(value => value)
      )
    def applicationId: Id
    def clientToken: Optional[ClientRequestToken]
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getClientToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleethub.model.DeleteApplicationRequest
  ) extends zio.aws.iotfleethub.model.DeleteApplicationRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.iotfleethub.model.primitives.Id(impl.applicationId())
    override val clientToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientToken())
        .map(value =>
          zio.aws.iotfleethub.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleethub.model.DeleteApplicationRequest
  ): zio.aws.iotfleethub.model.DeleteApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
