package zio.aws.iotfleethub
import zio.aws.iotfleethub.model.TagResourceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.iotfleethub.model.{
  UpdateApplicationRequest,
  DeleteApplicationRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  DescribeApplicationRequest,
  UntagResourceRequest,
  ListApplicationsRequest,
  TagResourceRequest
}
import software.amazon.awssdk.services.iotfleethub.model.{
  DescribeApplicationResponse,
  UpdateApplicationResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  ListApplicationsResponse,
  CreateApplicationResponse,
  TagResourceResponse,
  ApplicationSummary,
  DeleteApplicationResponse
}
import software.amazon.awssdk.services.iotfleethub.paginators.ListApplicationsPublisher
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.iotfleethub.{
  IoTFleetHubAsyncClientBuilder,
  IoTFleetHubAsyncClient
}
import scala.jdk.CollectionConverters._
trait IoTFleetHub extends AspectSupport[IoTFleetHub] {
  val api: IoTFleetHubAsyncClient
  def deleteApplication(
      request: DeleteApplicationRequest
  ): IO[AwsError, zio.aws.iotfleethub.model.DeleteApplicationResponse.ReadOnly]
  def describeApplication(request: DescribeApplicationRequest): IO[
    AwsError,
    zio.aws.iotfleethub.model.DescribeApplicationResponse.ReadOnly
  ]
  def createApplication(
      request: CreateApplicationRequest
  ): IO[AwsError, zio.aws.iotfleethub.model.CreateApplicationResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.iotfleethub.model.UntagResourceResponse.ReadOnly]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.iotfleethub.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[AwsError, ReadOnly]
  def listApplications(request: ListApplicationsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.iotfleethub.model.ApplicationSummary.ReadOnly
  ]
  def listApplicationsPaginated(
      request: ListApplicationsRequest
  ): IO[AwsError, zio.aws.iotfleethub.model.ListApplicationsResponse.ReadOnly]
  def updateApplication(
      request: UpdateApplicationRequest
  ): IO[AwsError, zio.aws.iotfleethub.model.UpdateApplicationResponse.ReadOnly]
}
object IoTFleetHub {
  val live: ZLayer[AwsConfig, java.lang.Throwable, IoTFleetHub] = customized(
    identity
  )
  def customized(
      customization: IoTFleetHubAsyncClientBuilder => IoTFleetHubAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, IoTFleetHub] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: IoTFleetHubAsyncClientBuilder => IoTFleetHubAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, IoTFleetHub] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = IoTFleetHubAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[IoTFleetHubAsyncClient, IoTFleetHubAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      IoTFleetHubAsyncClient,
      IoTFleetHubAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new IoTFleetHubImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class IoTFleetHubImpl[R](
      override val api: IoTFleetHubAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends IoTFleetHub
      with AwsServiceBase[R] {
    override val serviceName: String = "IoTFleetHub"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IoTFleetHubImpl[R1] = new IoTFleetHubImpl(api, newAspect, r)
    def deleteApplication(request: DeleteApplicationRequest): IO[
      AwsError,
      zio.aws.iotfleethub.model.DeleteApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleethub.model.DeleteApplicationRequest,
      DeleteApplicationResponse
    ]("deleteApplication", api.deleteApplication)(request.buildAwsValue())
      .map(zio.aws.iotfleethub.model.DeleteApplicationResponse.wrap)
      .provideEnvironment(r)
    def describeApplication(request: DescribeApplicationRequest): IO[
      AwsError,
      zio.aws.iotfleethub.model.DescribeApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleethub.model.DescribeApplicationRequest,
      DescribeApplicationResponse
    ]("describeApplication", api.describeApplication)(request.buildAwsValue())
      .map(zio.aws.iotfleethub.model.DescribeApplicationResponse.wrap)
      .provideEnvironment(r)
    def createApplication(request: CreateApplicationRequest): IO[
      AwsError,
      zio.aws.iotfleethub.model.CreateApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleethub.model.CreateApplicationRequest,
      CreateApplicationResponse
    ]("createApplication", api.createApplication)(request.buildAwsValue())
      .map(zio.aws.iotfleethub.model.CreateApplicationResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.iotfleethub.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotfleethub.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.iotfleethub.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.iotfleethub.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleethub.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.iotfleethub.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotfleethub.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.iotfleethub.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listApplications(request: ListApplicationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iotfleethub.model.ApplicationSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotfleethub.model.ListApplicationsRequest,
      ApplicationSummary,
      ListApplicationsPublisher
    ](
      "listApplications",
      api.listApplicationsPaginator,
      _.applicationSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.iotfleethub.model.ApplicationSummary.wrap(item))
      .provideEnvironment(r)
    def listApplicationsPaginated(request: ListApplicationsRequest): IO[
      AwsError,
      zio.aws.iotfleethub.model.ListApplicationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleethub.model.ListApplicationsRequest,
      ListApplicationsResponse
    ]("listApplications", api.listApplications)(request.buildAwsValue())
      .map(zio.aws.iotfleethub.model.ListApplicationsResponse.wrap)
      .provideEnvironment(r)
    def updateApplication(request: UpdateApplicationRequest): IO[
      AwsError,
      zio.aws.iotfleethub.model.UpdateApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleethub.model.UpdateApplicationRequest,
      UpdateApplicationResponse
    ]("updateApplication", api.updateApplication)(request.buildAwsValue())
      .map(zio.aws.iotfleethub.model.UpdateApplicationResponse.wrap)
      .provideEnvironment(r)
  }
  def deleteApplication(request: DeleteApplicationRequest): ZIO[
    zio.aws.iotfleethub.IoTFleetHub,
    AwsError,
    zio.aws.iotfleethub.model.DeleteApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApplication(request))
  def describeApplication(request: DescribeApplicationRequest): ZIO[
    zio.aws.iotfleethub.IoTFleetHub,
    AwsError,
    zio.aws.iotfleethub.model.DescribeApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeApplication(request))
  def createApplication(request: CreateApplicationRequest): ZIO[
    zio.aws.iotfleethub.IoTFleetHub,
    AwsError,
    zio.aws.iotfleethub.model.CreateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApplication(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.iotfleethub.IoTFleetHub,
    AwsError,
    zio.aws.iotfleethub.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.iotfleethub.IoTFleetHub,
    AwsError,
    zio.aws.iotfleethub.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(
      request: TagResourceRequest
  ): ZIO[zio.aws.iotfleethub.IoTFleetHub, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def listApplications(request: ListApplicationsRequest): ZStream[
    zio.aws.iotfleethub.IoTFleetHub,
    AwsError,
    zio.aws.iotfleethub.model.ApplicationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplications(request))
  def listApplicationsPaginated(request: ListApplicationsRequest): ZIO[
    zio.aws.iotfleethub.IoTFleetHub,
    AwsError,
    zio.aws.iotfleethub.model.ListApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationsPaginated(request))
  def updateApplication(request: UpdateApplicationRequest): ZIO[
    zio.aws.iotfleethub.IoTFleetHub,
    AwsError,
    zio.aws.iotfleethub.model.UpdateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApplication(request))
}
