package zio.aws.iotfleethub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotfleethub.model.primitives.{
  ErrorMessage,
  Url,
  Timestamp,
  TagValue,
  Arn,
  Description,
  SsoClientId,
  Name,
  Id,
  TagKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeApplicationResponse(
    applicationId: Id,
    applicationArn: Arn,
    applicationName: Name,
    applicationDescription: Optional[Description] = Optional.Absent,
    applicationUrl: Url,
    applicationState: zio.aws.iotfleethub.model.ApplicationState,
    applicationCreationDate: Timestamp,
    applicationLastUpdateDate: Timestamp,
    roleArn: Arn,
    ssoClientId: Optional[SsoClientId] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleethub.model.DescribeApplicationResponse = {
    import DescribeApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleethub.model.DescribeApplicationResponse
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .applicationArn(Arn.unwrap(applicationArn): java.lang.String)
      .applicationName(Name.unwrap(applicationName): java.lang.String)
      .optionallyWith(
        applicationDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.applicationDescription)
      .applicationUrl(Url.unwrap(applicationUrl): java.lang.String)
      .applicationState(applicationState.unwrap)
      .applicationCreationDate(
        Timestamp.unwrap(applicationCreationDate): java.lang.Long
      )
      .applicationLastUpdateDate(
        Timestamp.unwrap(applicationLastUpdateDate): java.lang.Long
      )
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        ssoClientId.map(value => SsoClientId.unwrap(value): java.lang.String)
      )(_.ssoClientId)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleethub.model.DescribeApplicationResponse.ReadOnly =
    zio.aws.iotfleethub.model.DescribeApplicationResponse.wrap(buildAwsValue())
}
object DescribeApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleethub.model.DescribeApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleethub.model.DescribeApplicationResponse =
      zio.aws.iotfleethub.model.DescribeApplicationResponse(
        applicationId,
        applicationArn,
        applicationName,
        applicationDescription.map(value => value),
        applicationUrl,
        applicationState,
        applicationCreationDate,
        applicationLastUpdateDate,
        roleArn,
        ssoClientId.map(value => value),
        errorMessage.map(value => value),
        tags.map(value => value)
      )
    def applicationId: Id
    def applicationArn: Arn
    def applicationName: Name
    def applicationDescription: Optional[Description]
    def applicationUrl: Url
    def applicationState: zio.aws.iotfleethub.model.ApplicationState
    def applicationCreationDate: Timestamp
    def applicationLastUpdateDate: Timestamp
    def roleArn: Arn
    def ssoClientId: Optional[SsoClientId]
    def errorMessage: Optional[ErrorMessage]
    def tags: Optional[Map[TagKey, TagValue]]
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getApplicationArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(applicationArn)
    def getApplicationName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(applicationName)
    def getApplicationDescription: ZIO[Any, AwsError, Description] = AwsError
      .unwrapOptionField("applicationDescription", applicationDescription)
    def getApplicationUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(applicationUrl)
    def getApplicationState
        : ZIO[Any, Nothing, zio.aws.iotfleethub.model.ApplicationState] =
      ZIO.succeed(applicationState)
    def getApplicationCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(applicationCreationDate)
    def getApplicationLastUpdateDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(applicationLastUpdateDate)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getSsoClientId: ZIO[Any, AwsError, SsoClientId] =
      AwsError.unwrapOptionField("ssoClientId", ssoClientId)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleethub.model.DescribeApplicationResponse
  ) extends zio.aws.iotfleethub.model.DescribeApplicationResponse.ReadOnly {
    override val applicationId: Id =
      zio.aws.iotfleethub.model.primitives.Id(impl.applicationId())
    override val applicationArn: Arn =
      zio.aws.iotfleethub.model.primitives.Arn(impl.applicationArn())
    override val applicationName: Name =
      zio.aws.iotfleethub.model.primitives.Name(impl.applicationName())
    override val applicationDescription: Optional[Description] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationDescription())
        .map(value => zio.aws.iotfleethub.model.primitives.Description(value))
    override val applicationUrl: Url =
      zio.aws.iotfleethub.model.primitives.Url(impl.applicationUrl())
    override val applicationState: zio.aws.iotfleethub.model.ApplicationState =
      zio.aws.iotfleethub.model.ApplicationState.wrap(impl.applicationState())
    override val applicationCreationDate: Timestamp =
      zio.aws.iotfleethub.model.primitives
        .Timestamp(impl.applicationCreationDate())
    override val applicationLastUpdateDate: Timestamp =
      zio.aws.iotfleethub.model.primitives
        .Timestamp(impl.applicationLastUpdateDate())
    override val roleArn: Arn =
      zio.aws.iotfleethub.model.primitives.Arn(impl.roleArn())
    override val ssoClientId: Optional[SsoClientId] = zio.aws.core.internal
      .optionalFromNullable(impl.ssoClientId())
      .map(value => zio.aws.iotfleethub.model.primitives.SsoClientId(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.iotfleethub.model.primitives.ErrorMessage(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iotfleethub.model.primitives.TagKey(
              key
            ) -> zio.aws.iotfleethub.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleethub.model.DescribeApplicationResponse
  ): zio.aws.iotfleethub.model.DescribeApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
