package zio.aws.iotfleethub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotfleethub.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListApplicationsRequest(
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleethub.model.ListApplicationsRequest = {
    import ListApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleethub.model.ListApplicationsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotfleethub.model.ListApplicationsRequest.ReadOnly =
    zio.aws.iotfleethub.model.ListApplicationsRequest.wrap(buildAwsValue())
}
object ListApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleethub.model.ListApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleethub.model.ListApplicationsRequest =
      zio.aws.iotfleethub.model
        .ListApplicationsRequest(nextToken.map(value => value))
    def nextToken: Optional[NextToken]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleethub.model.ListApplicationsRequest
  ) extends zio.aws.iotfleethub.model.ListApplicationsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleethub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleethub.model.ListApplicationsRequest
  ): zio.aws.iotfleethub.model.ListApplicationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
