package zio.aws.iotfleethub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotfleethub.model.primitives.{
  ClientRequestToken,
  Description,
  Name,
  Id
}
import scala.jdk.CollectionConverters._
final case class UpdateApplicationRequest(
    applicationId: Id,
    applicationName: Option[Name] = None,
    applicationDescription: Option[Description] = None,
    clientToken: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleethub.model.UpdateApplicationRequest = {
    import UpdateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleethub.model.UpdateApplicationRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        applicationName.map(value => Name.unwrap(value): java.lang.String)
      )(_.applicationName)
      .optionallyWith(
        applicationDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.applicationDescription)
      .optionallyWith(
        clientToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.iotfleethub.model.UpdateApplicationRequest.ReadOnly =
    zio.aws.iotfleethub.model.UpdateApplicationRequest.wrap(buildAwsValue())
}
object UpdateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleethub.model.UpdateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleethub.model.UpdateApplicationRequest =
      zio.aws.iotfleethub.model.UpdateApplicationRequest(
        applicationId,
        applicationName.map(value => value),
        applicationDescription.map(value => value),
        clientToken.map(value => value)
      )
    def applicationId: Id
    def applicationName: Option[Name]
    def applicationDescription: Option[Description]
    def clientToken: Option[ClientRequestToken]
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getApplicationName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getApplicationDescription: ZIO[Any, AwsError, Description] = AwsError
      .unwrapOptionField("applicationDescription", applicationDescription)
    def getClientToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleethub.model.UpdateApplicationRequest
  ) extends zio.aws.iotfleethub.model.UpdateApplicationRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.iotfleethub.model.primitives.Id(impl.applicationId())
    override val applicationName: Option[Name] = scala
      .Option(impl.applicationName())
      .map(value => zio.aws.iotfleethub.model.primitives.Name(value))
    override val applicationDescription: Option[Description] = scala
      .Option(impl.applicationDescription())
      .map(value => zio.aws.iotfleethub.model.primitives.Description(value))
    override val clientToken: Option[ClientRequestToken] = scala
      .Option(impl.clientToken())
      .map(value =>
        zio.aws.iotfleethub.model.primitives.ClientRequestToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleethub.model.UpdateApplicationRequest
  ): zio.aws.iotfleethub.model.UpdateApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
