package zio.aws.iotfleethub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotfleethub.model.primitives.{
  Url,
  Timestamp,
  Description,
  Name,
  Id
}
import scala.jdk.CollectionConverters._
final case class ApplicationSummary(
    applicationId: Id,
    applicationName: Name,
    applicationDescription: Option[Description] = None,
    applicationUrl: Url,
    applicationCreationDate: Option[Timestamp] = None,
    applicationLastUpdateDate: Option[Timestamp] = None,
    applicationState: Option[zio.aws.iotfleethub.model.ApplicationState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleethub.model.ApplicationSummary = {
    import ApplicationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleethub.model.ApplicationSummary
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .applicationName(Name.unwrap(applicationName): java.lang.String)
      .optionallyWith(
        applicationDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.applicationDescription)
      .applicationUrl(Url.unwrap(applicationUrl): java.lang.String)
      .optionallyWith(
        applicationCreationDate.map(value =>
          Timestamp.unwrap(value): java.lang.Long
        )
      )(_.applicationCreationDate)
      .optionallyWith(
        applicationLastUpdateDate.map(value =>
          Timestamp.unwrap(value): java.lang.Long
        )
      )(_.applicationLastUpdateDate)
      .optionallyWith(applicationState.map(value => value.unwrap))(
        _.applicationState
      )
      .build()
  }
  def asReadOnly: zio.aws.iotfleethub.model.ApplicationSummary.ReadOnly =
    zio.aws.iotfleethub.model.ApplicationSummary.wrap(buildAwsValue())
}
object ApplicationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleethub.model.ApplicationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleethub.model.ApplicationSummary =
      zio.aws.iotfleethub.model.ApplicationSummary(
        applicationId,
        applicationName,
        applicationDescription.map(value => value),
        applicationUrl,
        applicationCreationDate.map(value => value),
        applicationLastUpdateDate.map(value => value),
        applicationState.map(value => value)
      )
    def applicationId: Id
    def applicationName: Name
    def applicationDescription: Option[Description]
    def applicationUrl: Url
    def applicationCreationDate: Option[Timestamp]
    def applicationLastUpdateDate: Option[Timestamp]
    def applicationState: Option[zio.aws.iotfleethub.model.ApplicationState]
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getApplicationName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(applicationName)
    def getApplicationDescription: ZIO[Any, AwsError, Description] = AwsError
      .unwrapOptionField("applicationDescription", applicationDescription)
    def getApplicationUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(applicationUrl)
    def getApplicationCreationDate: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("applicationCreationDate", applicationCreationDate)
    def getApplicationLastUpdateDate: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("applicationLastUpdateDate", applicationLastUpdateDate)
    def getApplicationState
        : ZIO[Any, AwsError, zio.aws.iotfleethub.model.ApplicationState] =
      AwsError.unwrapOptionField("applicationState", applicationState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleethub.model.ApplicationSummary
  ) extends zio.aws.iotfleethub.model.ApplicationSummary.ReadOnly {
    override val applicationId: Id =
      zio.aws.iotfleethub.model.primitives.Id(impl.applicationId())
    override val applicationName: Name =
      zio.aws.iotfleethub.model.primitives.Name(impl.applicationName())
    override val applicationDescription: Option[Description] = scala
      .Option(impl.applicationDescription())
      .map(value => zio.aws.iotfleethub.model.primitives.Description(value))
    override val applicationUrl: Url =
      zio.aws.iotfleethub.model.primitives.Url(impl.applicationUrl())
    override val applicationCreationDate: Option[Timestamp] = scala
      .Option(impl.applicationCreationDate())
      .map(value => zio.aws.iotfleethub.model.primitives.Timestamp(value))
    override val applicationLastUpdateDate: Option[Timestamp] = scala
      .Option(impl.applicationLastUpdateDate())
      .map(value => zio.aws.iotfleethub.model.primitives.Timestamp(value))
    override val applicationState
        : Option[zio.aws.iotfleethub.model.ApplicationState] = scala
      .Option(impl.applicationState())
      .map(value => zio.aws.iotfleethub.model.ApplicationState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleethub.model.ApplicationSummary
  ): zio.aws.iotfleethub.model.ApplicationSummary.ReadOnly = new Wrapper(impl)
}
