package zio.aws.iotdeviceadvisor.model
import scala.jdk.CollectionConverters._
sealed trait AuthenticationMethod {
  def unwrap: software.amazon.awssdk.services.iotdeviceadvisor.model.AuthenticationMethod
}
object AuthenticationMethod {
  def wrap(
      value: software.amazon.awssdk.services.iotdeviceadvisor.model.AuthenticationMethod
  ): zio.aws.iotdeviceadvisor.model.AuthenticationMethod = value match {
    case software.amazon.awssdk.services.iotdeviceadvisor.model.AuthenticationMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.AuthenticationMethod.X509_CLIENT_CERTIFICATE =>
      val r = X509ClientCertificate
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.AuthenticationMethod.SIGNATURE_VERSION4 =>
      val r = SignatureVersion4
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotdeviceadvisor.model.AuthenticationMethod {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.AuthenticationMethod =
      software.amazon.awssdk.services.iotdeviceadvisor.model.AuthenticationMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object X509ClientCertificate
      extends zio.aws.iotdeviceadvisor.model.AuthenticationMethod {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.AuthenticationMethod =
      software.amazon.awssdk.services.iotdeviceadvisor.model.AuthenticationMethod.X509_CLIENT_CERTIFICATE
  }
  case object SignatureVersion4
      extends zio.aws.iotdeviceadvisor.model.AuthenticationMethod {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.AuthenticationMethod =
      software.amazon.awssdk.services.iotdeviceadvisor.model.AuthenticationMethod.SIGNATURE_VERSION4
  }
}
