package zio.aws.iotdeviceadvisor.model
import zio.aws.iotdeviceadvisor.model.primitives.{
  Timestamp,
  AmazonResourceName,
  UUID,
  SuiteDefinitionVersion,
  String128,
  String256,
  ErrorReason
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetSuiteRunResponse(
    suiteDefinitionId: Optional[UUID] = Optional.Absent,
    suiteDefinitionVersion: Optional[SuiteDefinitionVersion] = Optional.Absent,
    suiteRunId: Optional[UUID] = Optional.Absent,
    suiteRunArn: Optional[AmazonResourceName] = Optional.Absent,
    suiteRunConfiguration: Optional[
      zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration
    ] = Optional.Absent,
    testResult: Optional[zio.aws.iotdeviceadvisor.model.TestResult] =
      Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.iotdeviceadvisor.model.SuiteRunStatus] =
      Optional.Absent,
    errorReason: Optional[ErrorReason] = Optional.Absent,
    tags: Optional[Map[String128, String256]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunResponse = {
    import GetSuiteRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunResponse
      .builder()
      .optionallyWith(
        suiteDefinitionId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.suiteDefinitionId)
      .optionallyWith(
        suiteDefinitionVersion.map(value =>
          SuiteDefinitionVersion.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionVersion)
      .optionallyWith(
        suiteRunId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.suiteRunId)
      .optionallyWith(
        suiteRunArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.suiteRunArn)
      .optionallyWith(
        suiteRunConfiguration.map(value => value.buildAwsValue())
      )(_.suiteRunConfiguration)
      .optionallyWith(testResult.map(value => value.buildAwsValue()))(
        _.testResult
      )
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        errorReason.map(value => ErrorReason.unwrap(value): java.lang.String)
      )(_.errorReason)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (String128.unwrap(key): java.lang.String) -> (String256
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iotdeviceadvisor.model.GetSuiteRunResponse.ReadOnly =
    zio.aws.iotdeviceadvisor.model.GetSuiteRunResponse.wrap(buildAwsValue())
}
object GetSuiteRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.GetSuiteRunResponse =
      zio.aws.iotdeviceadvisor.model.GetSuiteRunResponse(
        suiteDefinitionId.map(value => value),
        suiteDefinitionVersion.map(value => value),
        suiteRunId.map(value => value),
        suiteRunArn.map(value => value),
        suiteRunConfiguration.map(value => value.asEditable),
        testResult.map(value => value.asEditable),
        startTime.map(value => value),
        endTime.map(value => value),
        status.map(value => value),
        errorReason.map(value => value),
        tags.map(value => value)
      )
    def suiteDefinitionId: Optional[UUID]
    def suiteDefinitionVersion: Optional[SuiteDefinitionVersion]
    def suiteRunId: Optional[UUID]
    def suiteRunArn: Optional[AmazonResourceName]
    def suiteRunConfiguration: Optional[
      zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.ReadOnly
    ]
    def testResult: Optional[zio.aws.iotdeviceadvisor.model.TestResult.ReadOnly]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def status: Optional[zio.aws.iotdeviceadvisor.model.SuiteRunStatus]
    def errorReason: Optional[ErrorReason]
    def tags: Optional[Map[String128, String256]]
    def getSuiteDefinitionId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("suiteDefinitionId", suiteDefinitionId)
    def getSuiteDefinitionVersion: ZIO[Any, AwsError, SuiteDefinitionVersion] =
      AwsError.unwrapOptionField(
        "suiteDefinitionVersion",
        suiteDefinitionVersion
      )
    def getSuiteRunId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("suiteRunId", suiteRunId)
    def getSuiteRunArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("suiteRunArn", suiteRunArn)
    def getSuiteRunConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("suiteRunConfiguration", suiteRunConfiguration)
    def getTestResult: ZIO[
      Any,
      AwsError,
      zio.aws.iotdeviceadvisor.model.TestResult.ReadOnly
    ] = AwsError.unwrapOptionField("testResult", testResult)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotdeviceadvisor.model.SuiteRunStatus] =
      AwsError.unwrapOptionField("status", status)
    def getErrorReason: ZIO[Any, AwsError, ErrorReason] =
      AwsError.unwrapOptionField("errorReason", errorReason)
    def getTags: ZIO[Any, AwsError, Map[String128, String256]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunResponse
  ) extends zio.aws.iotdeviceadvisor.model.GetSuiteRunResponse.ReadOnly {
    override val suiteDefinitionId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.suiteDefinitionId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val suiteDefinitionVersion: Optional[SuiteDefinitionVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suiteDefinitionVersion())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives
            .SuiteDefinitionVersion(value)
        )
    override val suiteRunId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.suiteRunId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val suiteRunArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suiteRunArn())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName(value)
        )
    override val suiteRunConfiguration: Optional[
      zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.suiteRunConfiguration())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.wrap(value)
      )
    override val testResult
        : Optional[zio.aws.iotdeviceadvisor.model.TestResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testResult())
        .map(value => zio.aws.iotdeviceadvisor.model.TestResult.wrap(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
    override val status
        : Optional[zio.aws.iotdeviceadvisor.model.SuiteRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotdeviceadvisor.model.SuiteRunStatus.wrap(value))
    override val errorReason: Optional[ErrorReason] = zio.aws.core.internal
      .optionalFromNullable(impl.errorReason())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.ErrorReason(value)
      )
    override val tags: Optional[Map[String128, String256]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iotdeviceadvisor.model.primitives.String128(
                key
              ) -> zio.aws.iotdeviceadvisor.model.primitives.String256(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunResponse
  ): zio.aws.iotdeviceadvisor.model.GetSuiteRunResponse.ReadOnly = new Wrapper(
    impl
  )
}
