package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotdeviceadvisor.model.primitives.{
  SuiteDefinitionName,
  IntendedForQualificationBoolean,
  IsLongDurationTestBoolean,
  RootGroup,
  AmazonResourceName
}
import scala.jdk.CollectionConverters._
final case class SuiteDefinitionConfiguration(
    suiteDefinitionName: SuiteDefinitionName,
    devices: Optional[
      Iterable[zio.aws.iotdeviceadvisor.model.DeviceUnderTest]
    ] = Optional.Absent,
    intendedForQualification: Optional[IntendedForQualificationBoolean] =
      Optional.Absent,
    isLongDurationTest: Optional[IsLongDurationTestBoolean] = Optional.Absent,
    rootGroup: RootGroup,
    devicePermissionRoleArn: AmazonResourceName,
    protocol: Optional[zio.aws.iotdeviceadvisor.model.Protocol] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionConfiguration = {
    import SuiteDefinitionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionConfiguration
      .builder()
      .suiteDefinitionName(
        SuiteDefinitionName.unwrap(suiteDefinitionName): java.lang.String
      )
      .optionallyWith(
        devices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.devices)
      .optionallyWith(
        intendedForQualification.map(value =>
          IntendedForQualificationBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.intendedForQualification)
      .optionallyWith(
        isLongDurationTest.map(value =>
          IsLongDurationTestBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.isLongDurationTest)
      .rootGroup(RootGroup.unwrap(rootGroup): java.lang.String)
      .devicePermissionRoleArn(
        AmazonResourceName.unwrap(devicePermissionRoleArn): java.lang.String
      )
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly =
    zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration
      .wrap(buildAwsValue())
}
object SuiteDefinitionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration =
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration(
        suiteDefinitionName,
        devices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        intendedForQualification.map(value => value),
        isLongDurationTest.map(value => value),
        rootGroup,
        devicePermissionRoleArn,
        protocol.map(value => value)
      )
    def suiteDefinitionName: SuiteDefinitionName
    def devices: Optional[
      List[zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly]
    ]
    def intendedForQualification: Optional[IntendedForQualificationBoolean]
    def isLongDurationTest: Optional[IsLongDurationTestBoolean]
    def rootGroup: RootGroup
    def devicePermissionRoleArn: AmazonResourceName
    def protocol: Optional[zio.aws.iotdeviceadvisor.model.Protocol]
    def getSuiteDefinitionName: ZIO[Any, Nothing, SuiteDefinitionName] =
      ZIO.succeed(suiteDefinitionName)
    def getDevices: ZIO[Any, AwsError, List[
      zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly
    ]] = AwsError.unwrapOptionField("devices", devices)
    def getIntendedForQualification
        : ZIO[Any, AwsError, IntendedForQualificationBoolean] = AwsError
      .unwrapOptionField("intendedForQualification", intendedForQualification)
    def getIsLongDurationTest: ZIO[Any, AwsError, IsLongDurationTestBoolean] =
      AwsError.unwrapOptionField("isLongDurationTest", isLongDurationTest)
    def getRootGroup: ZIO[Any, Nothing, RootGroup] = ZIO.succeed(rootGroup)
    def getDevicePermissionRoleArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(devicePermissionRoleArn)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.iotdeviceadvisor.model.Protocol] =
      AwsError.unwrapOptionField("protocol", protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionConfiguration
  ) extends zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly {
    override val suiteDefinitionName: SuiteDefinitionName =
      zio.aws.iotdeviceadvisor.model.primitives
        .SuiteDefinitionName(impl.suiteDefinitionName())
    override val devices: Optional[
      List[zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.devices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotdeviceadvisor.model.DeviceUnderTest.wrap(item)
        }.toList
      )
    override val intendedForQualification
        : Optional[IntendedForQualificationBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.intendedForQualification())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives
          .IntendedForQualificationBoolean(value)
      )
    override val isLongDurationTest: Optional[IsLongDurationTestBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isLongDurationTest())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives
            .IsLongDurationTestBoolean(value)
        )
    override val rootGroup: RootGroup =
      zio.aws.iotdeviceadvisor.model.primitives.RootGroup(impl.rootGroup())
    override val devicePermissionRoleArn: AmazonResourceName =
      zio.aws.iotdeviceadvisor.model.primitives
        .AmazonResourceName(impl.devicePermissionRoleArn())
    override val protocol: Optional[zio.aws.iotdeviceadvisor.model.Protocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.iotdeviceadvisor.model.Protocol.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionConfiguration
  ): zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly =
    new Wrapper(impl)
}
