package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName
import scala.jdk.CollectionConverters._
final case class GetEndpointRequest(
    thingArn: Optional[AmazonResourceName] = Optional.Absent,
    certificateArn: Optional[AmazonResourceName] = Optional.Absent,
    deviceRoleArn: Optional[AmazonResourceName] = Optional.Absent,
    authenticationMethod: Optional[
      zio.aws.iotdeviceadvisor.model.AuthenticationMethod
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointRequest = {
    import GetEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointRequest
      .builder()
      .optionallyWith(
        thingArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.thingArn)
      .optionallyWith(
        certificateArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        deviceRoleArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.deviceRoleArn)
      .optionallyWith(authenticationMethod.map(value => value.unwrap))(
        _.authenticationMethod
      )
      .build()
  }
  def asReadOnly: zio.aws.iotdeviceadvisor.model.GetEndpointRequest.ReadOnly =
    zio.aws.iotdeviceadvisor.model.GetEndpointRequest.wrap(buildAwsValue())
}
object GetEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.GetEndpointRequest =
      zio.aws.iotdeviceadvisor.model.GetEndpointRequest(
        thingArn.map(value => value),
        certificateArn.map(value => value),
        deviceRoleArn.map(value => value),
        authenticationMethod.map(value => value)
      )
    def thingArn: Optional[AmazonResourceName]
    def certificateArn: Optional[AmazonResourceName]
    def deviceRoleArn: Optional[AmazonResourceName]
    def authenticationMethod
        : Optional[zio.aws.iotdeviceadvisor.model.AuthenticationMethod]
    def getThingArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("thingArn", thingArn)
    def getCertificateArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getDeviceRoleArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("deviceRoleArn", deviceRoleArn)
    def getAuthenticationMethod: ZIO[
      Any,
      AwsError,
      zio.aws.iotdeviceadvisor.model.AuthenticationMethod
    ] = AwsError.unwrapOptionField("authenticationMethod", authenticationMethod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointRequest
  ) extends zio.aws.iotdeviceadvisor.model.GetEndpointRequest.ReadOnly {
    override val thingArn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingArn())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName(value)
      )
    override val certificateArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName(value)
        )
    override val deviceRoleArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceRoleArn())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName(value)
        )
    override val authenticationMethod
        : Optional[zio.aws.iotdeviceadvisor.model.AuthenticationMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationMethod())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.AuthenticationMethod.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointRequest
  ): zio.aws.iotdeviceadvisor.model.GetEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
