package zio.aws.iotdeviceadvisor.model
import zio.aws.iotdeviceadvisor.model.primitives.{
  Token,
  MaxResults,
  SuiteDefinitionVersion,
  UUID
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSuiteRunsRequest(
    suiteDefinitionId: Optional[UUID] = Optional.Absent,
    suiteDefinitionVersion: Optional[SuiteDefinitionVersion] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest = {
    import ListSuiteRunsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest
      .builder()
      .optionallyWith(
        suiteDefinitionId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.suiteDefinitionId)
      .optionallyWith(
        suiteDefinitionVersion.map(value =>
          SuiteDefinitionVersion.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionVersion)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotdeviceadvisor.model.ListSuiteRunsRequest.ReadOnly =
    zio.aws.iotdeviceadvisor.model.ListSuiteRunsRequest.wrap(buildAwsValue())
}
object ListSuiteRunsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.ListSuiteRunsRequest =
      zio.aws.iotdeviceadvisor.model.ListSuiteRunsRequest(
        suiteDefinitionId.map(value => value),
        suiteDefinitionVersion.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def suiteDefinitionId: Optional[UUID]
    def suiteDefinitionVersion: Optional[SuiteDefinitionVersion]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[Token]
    def getSuiteDefinitionId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("suiteDefinitionId", suiteDefinitionId)
    def getSuiteDefinitionVersion: ZIO[Any, AwsError, SuiteDefinitionVersion] =
      AwsError.unwrapOptionField(
        "suiteDefinitionVersion",
        suiteDefinitionVersion
      )
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest
  ) extends zio.aws.iotdeviceadvisor.model.ListSuiteRunsRequest.ReadOnly {
    override val suiteDefinitionId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.suiteDefinitionId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val suiteDefinitionVersion: Optional[SuiteDefinitionVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suiteDefinitionVersion())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives
            .SuiteDefinitionVersion(value)
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.MaxResults(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest
  ): zio.aws.iotdeviceadvisor.model.ListSuiteRunsRequest.ReadOnly = new Wrapper(
    impl
  )
}
