package zio.aws.iotdeviceadvisor.model
import scala.jdk.CollectionConverters._
sealed trait SuiteRunStatus {
  def unwrap
      : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus
}
object SuiteRunStatus {
  def wrap(
      value: software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus
  ): zio.aws.iotdeviceadvisor.model.SuiteRunStatus = value match {
    case software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.PASS =>
      val r = PASS
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.FAIL =>
      val r = FAIL
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.CANCELED =>
      val r = CANCELED
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.PASS_WITH_WARNINGS =>
      val r = PASS_WITH_WARNINGS
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotdeviceadvisor.model.SuiteRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus =
      software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PASS extends zio.aws.iotdeviceadvisor.model.SuiteRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus =
      software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.PASS
  }
  case object FAIL extends zio.aws.iotdeviceadvisor.model.SuiteRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus =
      software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.FAIL
  }
  case object CANCELED extends zio.aws.iotdeviceadvisor.model.SuiteRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus =
      software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.CANCELED
  }
  case object PENDING extends zio.aws.iotdeviceadvisor.model.SuiteRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus =
      software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.PENDING
  }
  case object RUNNING extends zio.aws.iotdeviceadvisor.model.SuiteRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus =
      software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.RUNNING
  }
  case object STOPPING extends zio.aws.iotdeviceadvisor.model.SuiteRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus =
      software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.STOPPING
  }
  case object STOPPED extends zio.aws.iotdeviceadvisor.model.SuiteRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus =
      software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.STOPPED
  }
  case object PASS_WITH_WARNINGS
      extends zio.aws.iotdeviceadvisor.model.SuiteRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus =
      software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.PASS_WITH_WARNINGS
  }
  case object ERROR extends zio.aws.iotdeviceadvisor.model.SuiteRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus =
      software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus.ERROR
  }
}
