package zio.aws.iotdeviceadvisor.model
import zio.aws.iotdeviceadvisor.model.primitives.{
  Timestamp,
  SuiteDefinitionName,
  AmazonResourceName,
  UUID
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateSuiteDefinitionResponse(
    suiteDefinitionId: Optional[UUID] = Optional.Absent,
    suiteDefinitionArn: Optional[AmazonResourceName] = Optional.Absent,
    suiteDefinitionName: Optional[SuiteDefinitionName] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.CreateSuiteDefinitionResponse = {
    import CreateSuiteDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.CreateSuiteDefinitionResponse
      .builder()
      .optionallyWith(
        suiteDefinitionId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.suiteDefinitionId)
      .optionallyWith(
        suiteDefinitionArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionArn)
      .optionallyWith(
        suiteDefinitionName.map(value =>
          SuiteDefinitionName.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionName)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionResponse.ReadOnly =
    zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionResponse
      .wrap(buildAwsValue())
}
object CreateSuiteDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.CreateSuiteDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionResponse =
      zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionResponse(
        suiteDefinitionId.map(value => value),
        suiteDefinitionArn.map(value => value),
        suiteDefinitionName.map(value => value),
        createdAt.map(value => value)
      )
    def suiteDefinitionId: Optional[UUID]
    def suiteDefinitionArn: Optional[AmazonResourceName]
    def suiteDefinitionName: Optional[SuiteDefinitionName]
    def createdAt: Optional[Timestamp]
    def getSuiteDefinitionId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("suiteDefinitionId", suiteDefinitionId)
    def getSuiteDefinitionArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("suiteDefinitionArn", suiteDefinitionArn)
    def getSuiteDefinitionName: ZIO[Any, AwsError, SuiteDefinitionName] =
      AwsError.unwrapOptionField("suiteDefinitionName", suiteDefinitionName)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.CreateSuiteDefinitionResponse
  ) extends zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionResponse.ReadOnly {
    override val suiteDefinitionId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.suiteDefinitionId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val suiteDefinitionArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suiteDefinitionArn())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName(value)
        )
    override val suiteDefinitionName: Optional[SuiteDefinitionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suiteDefinitionName())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives.SuiteDefinitionName(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.CreateSuiteDefinitionResponse
  ): zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
