package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotdeviceadvisor.model.primitives.{
  String256,
  String128,
  AmazonResourceName
}
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: AmazonResourceName,
    tags: Map[String128, String256]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.TagResourceRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (String128.unwrap(key): java.lang.String) -> (String256
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.iotdeviceadvisor.model.TagResourceRequest.ReadOnly =
    zio.aws.iotdeviceadvisor.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.TagResourceRequest =
      zio.aws.iotdeviceadvisor.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: AmazonResourceName
    def tags: Map[String128, String256]
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[String128, String256]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.TagResourceRequest
  ) extends zio.aws.iotdeviceadvisor.model.TagResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.iotdeviceadvisor.model.primitives
        .AmazonResourceName(impl.resourceArn())
    override val tags: Map[String128, String256] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.iotdeviceadvisor.model.primitives.String128(
          key
        ) -> zio.aws.iotdeviceadvisor.model.primitives.String256(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.TagResourceRequest
  ): zio.aws.iotdeviceadvisor.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
