package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotdeviceadvisor.model.primitives.{
  SystemMessage,
  Failure,
  TestCaseScenarioId
}
import scala.jdk.CollectionConverters._
final case class TestCaseScenario(
    testCaseScenarioId: Optional[TestCaseScenarioId] = Optional.Absent,
    testCaseScenarioType: Optional[
      zio.aws.iotdeviceadvisor.model.TestCaseScenarioType
    ] = Optional.Absent,
    status: Optional[zio.aws.iotdeviceadvisor.model.TestCaseScenarioStatus] =
      Optional.Absent,
    failure: Optional[Failure] = Optional.Absent,
    systemMessage: Optional[SystemMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseScenario = {
    import TestCaseScenario.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseScenario
      .builder()
      .optionallyWith(
        testCaseScenarioId.map(value =>
          TestCaseScenarioId.unwrap(value): java.lang.String
        )
      )(_.testCaseScenarioId)
      .optionallyWith(testCaseScenarioType.map(value => value.unwrap))(
        _.testCaseScenarioType
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        failure.map(value => Failure.unwrap(value): java.lang.String)
      )(_.failure)
      .optionallyWith(
        systemMessage.map(value =>
          SystemMessage.unwrap(value): java.lang.String
        )
      )(_.systemMessage)
      .build()
  }
  def asReadOnly: zio.aws.iotdeviceadvisor.model.TestCaseScenario.ReadOnly =
    zio.aws.iotdeviceadvisor.model.TestCaseScenario.wrap(buildAwsValue())
}
object TestCaseScenario {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseScenario
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.TestCaseScenario =
      zio.aws.iotdeviceadvisor.model.TestCaseScenario(
        testCaseScenarioId.map(value => value),
        testCaseScenarioType.map(value => value),
        status.map(value => value),
        failure.map(value => value),
        systemMessage.map(value => value)
      )
    def testCaseScenarioId: Optional[TestCaseScenarioId]
    def testCaseScenarioType
        : Optional[zio.aws.iotdeviceadvisor.model.TestCaseScenarioType]
    def status: Optional[zio.aws.iotdeviceadvisor.model.TestCaseScenarioStatus]
    def failure: Optional[Failure]
    def systemMessage: Optional[SystemMessage]
    def getTestCaseScenarioId: ZIO[Any, AwsError, TestCaseScenarioId] =
      AwsError.unwrapOptionField("testCaseScenarioId", testCaseScenarioId)
    def getTestCaseScenarioType: ZIO[
      Any,
      AwsError,
      zio.aws.iotdeviceadvisor.model.TestCaseScenarioType
    ] = AwsError.unwrapOptionField("testCaseScenarioType", testCaseScenarioType)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotdeviceadvisor.model.TestCaseScenarioStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getFailure: ZIO[Any, AwsError, Failure] =
      AwsError.unwrapOptionField("failure", failure)
    def getSystemMessage: ZIO[Any, AwsError, SystemMessage] =
      AwsError.unwrapOptionField("systemMessage", systemMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseScenario
  ) extends zio.aws.iotdeviceadvisor.model.TestCaseScenario.ReadOnly {
    override val testCaseScenarioId: Optional[TestCaseScenarioId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testCaseScenarioId())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives.TestCaseScenarioId(value)
        )
    override val testCaseScenarioType
        : Optional[zio.aws.iotdeviceadvisor.model.TestCaseScenarioType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testCaseScenarioType())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.TestCaseScenarioType.wrap(value)
        )
    override val status
        : Optional[zio.aws.iotdeviceadvisor.model.TestCaseScenarioStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.TestCaseScenarioStatus.wrap(value)
        )
    override val failure: Optional[Failure] = zio.aws.core.internal
      .optionalFromNullable(impl.failure())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Failure(value))
    override val systemMessage: Optional[SystemMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.systemMessage())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.SystemMessage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseScenario
  ): zio.aws.iotdeviceadvisor.model.TestCaseScenario.ReadOnly = new Wrapper(
    impl
  )
}
