package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotdeviceadvisor.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListSuiteRunsResponse(
    suiteRunsList: Optional[
      Iterable[zio.aws.iotdeviceadvisor.model.SuiteRunInformation]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsResponse = {
    import ListSuiteRunsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsResponse
      .builder()
      .optionallyWith(
        suiteRunsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.suiteRunsList)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.ListSuiteRunsResponse.ReadOnly =
    zio.aws.iotdeviceadvisor.model.ListSuiteRunsResponse.wrap(buildAwsValue())
}
object ListSuiteRunsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.ListSuiteRunsResponse =
      zio.aws.iotdeviceadvisor.model.ListSuiteRunsResponse(
        suiteRunsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def suiteRunsList: Optional[
      List[zio.aws.iotdeviceadvisor.model.SuiteRunInformation.ReadOnly]
    ]
    def nextToken: Optional[Token]
    def getSuiteRunsList: ZIO[Any, AwsError, List[
      zio.aws.iotdeviceadvisor.model.SuiteRunInformation.ReadOnly
    ]] = AwsError.unwrapOptionField("suiteRunsList", suiteRunsList)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsResponse
  ) extends zio.aws.iotdeviceadvisor.model.ListSuiteRunsResponse.ReadOnly {
    override val suiteRunsList: Optional[
      List[zio.aws.iotdeviceadvisor.model.SuiteRunInformation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.suiteRunsList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotdeviceadvisor.model.SuiteRunInformation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsResponse
  ): zio.aws.iotdeviceadvisor.model.ListSuiteRunsResponse.ReadOnly =
    new Wrapper(impl)
}
