package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotdeviceadvisor.model.primitives.UUID
import scala.jdk.CollectionConverters._
final case class UpdateSuiteDefinitionRequest(
    suiteDefinitionId: UUID,
    suiteDefinitionConfiguration: zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest = {
    import UpdateSuiteDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest
      .builder()
      .suiteDefinitionId(UUID.unwrap(suiteDefinitionId): java.lang.String)
      .suiteDefinitionConfiguration(
        suiteDefinitionConfiguration.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest.ReadOnly =
    zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest
      .wrap(buildAwsValue())
}
object UpdateSuiteDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest =
      zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest(
        suiteDefinitionId,
        suiteDefinitionConfiguration.asEditable
      )
    def suiteDefinitionId: UUID
    def suiteDefinitionConfiguration
        : zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly
    def getSuiteDefinitionId: ZIO[Any, Nothing, UUID] =
      ZIO.succeed(suiteDefinitionId)
    def getSuiteDefinitionConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly
    ] = ZIO.succeed(suiteDefinitionConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest
  ) extends zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest.ReadOnly {
    override val suiteDefinitionId: UUID =
      zio.aws.iotdeviceadvisor.model.primitives.UUID(impl.suiteDefinitionId())
    override val suiteDefinitionConfiguration
        : zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly =
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration
        .wrap(impl.suiteDefinitionConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest
  ): zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
