package zio.aws.iotdeviceadvisor.model
import zio.aws.iotdeviceadvisor.model.primitives.{Token, MaxResults}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSuiteDefinitionsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest = {
    import ListSuiteDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsRequest.ReadOnly =
    zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsRequest
      .wrap(buildAwsValue())
}
object ListSuiteDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsRequest =
      zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[Token]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest
  ) extends zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.MaxResults(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest
  ): zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsRequest.ReadOnly =
    new Wrapper(impl)
}
