package zio.aws.iotdeviceadvisor
import zio.aws.iotdeviceadvisor.model.GetSuiteRunReportResponse.ReadOnly
import software.amazon.awssdk.services.iotdeviceadvisor.{
  IotDeviceAdvisorAsyncClientBuilder,
  IotDeviceAdvisorAsyncClient
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.iotdeviceadvisor.model.{
  GetSuiteRunReportRequest,
  DeleteSuiteDefinitionResponse,
  StartSuiteRunRequest,
  GetEndpointResponse,
  CreateSuiteDefinitionRequest,
  GetSuiteRunReportResponse,
  ListSuiteDefinitionsRequest,
  GetSuiteDefinitionResponse,
  UpdateSuiteDefinitionResponse,
  UpdateSuiteDefinitionRequest,
  GetSuiteDefinitionRequest,
  ListTagsForResourceRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  GetSuiteRunResponse,
  DeleteSuiteDefinitionRequest,
  ListSuiteDefinitionsResponse,
  GetEndpointRequest,
  ListSuiteRunsRequest,
  UntagResourceRequest,
  StopSuiteRunRequest,
  CreateSuiteDefinitionResponse,
  StopSuiteRunResponse,
  GetSuiteRunRequest,
  ListSuiteRunsResponse,
  StartSuiteRunResponse,
  TagResourceResponse,
  TagResourceRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import scala.jdk.CollectionConverters._
trait IotDeviceAdvisor extends AspectSupport[IotDeviceAdvisor] {
  val api: IotDeviceAdvisorAsyncClient
  def getEndpoint(
      request: zio.aws.iotdeviceadvisor.model.GetEndpointRequest
  ): IO[AwsError, zio.aws.iotdeviceadvisor.model.GetEndpointResponse.ReadOnly]
  def updateSuiteDefinition(
      request: zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest
  ): IO[
    AwsError,
    zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse.ReadOnly
  ]
  def listSuiteRuns(
      request: zio.aws.iotdeviceadvisor.model.ListSuiteRunsRequest
  ): IO[AwsError, zio.aws.iotdeviceadvisor.model.ListSuiteRunsResponse.ReadOnly]
  def listSuiteDefinitions(
      request: zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsRequest
  ): IO[
    AwsError,
    zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsResponse.ReadOnly
  ]
  def stopSuiteRun(
      request: zio.aws.iotdeviceadvisor.model.StopSuiteRunRequest
  ): IO[AwsError, zio.aws.iotdeviceadvisor.model.StopSuiteRunResponse.ReadOnly]
  def getSuiteDefinition(
      request: zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionRequest
  ): IO[
    AwsError,
    zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.iotdeviceadvisor.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.iotdeviceadvisor.model.UntagResourceResponse.ReadOnly]
  def getSuiteRun(
      request: zio.aws.iotdeviceadvisor.model.GetSuiteRunRequest
  ): IO[AwsError, zio.aws.iotdeviceadvisor.model.GetSuiteRunResponse.ReadOnly]
  def deleteSuiteDefinition(
      request: zio.aws.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest
  ): IO[
    AwsError,
    zio.aws.iotdeviceadvisor.model.DeleteSuiteDefinitionResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.iotdeviceadvisor.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.iotdeviceadvisor.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.iotdeviceadvisor.model.TagResourceRequest
  ): IO[AwsError, zio.aws.iotdeviceadvisor.model.TagResourceResponse.ReadOnly]
  def getSuiteRunReport(
      request: zio.aws.iotdeviceadvisor.model.GetSuiteRunReportRequest
  ): IO[AwsError, ReadOnly]
  def startSuiteRun(
      request: zio.aws.iotdeviceadvisor.model.StartSuiteRunRequest
  ): IO[AwsError, zio.aws.iotdeviceadvisor.model.StartSuiteRunResponse.ReadOnly]
  def createSuiteDefinition(
      request: zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionRequest
  ): IO[
    AwsError,
    zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionResponse.ReadOnly
  ]
}
object IotDeviceAdvisor {
  val live: ZLayer[AwsConfig, java.lang.Throwable, IotDeviceAdvisor] =
    customized(identity)
  def customized(
      customization: IotDeviceAdvisorAsyncClientBuilder => IotDeviceAdvisorAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, IotDeviceAdvisor] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: IotDeviceAdvisorAsyncClientBuilder => IotDeviceAdvisorAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, IotDeviceAdvisor] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = IotDeviceAdvisorAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      IotDeviceAdvisorAsyncClient,
      IotDeviceAdvisorAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      IotDeviceAdvisorAsyncClient,
      IotDeviceAdvisorAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new IotDeviceAdvisorImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class IotDeviceAdvisorImpl[R](
      override val api: IotDeviceAdvisorAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends IotDeviceAdvisor
      with AwsServiceBase[R] {
    override val serviceName: String = "IotDeviceAdvisor"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IotDeviceAdvisorImpl[R1] = new IotDeviceAdvisorImpl(api, newAspect, r)
    def getEndpoint(
        request: zio.aws.iotdeviceadvisor.model.GetEndpointRequest
    ): IO[
      AwsError,
      zio.aws.iotdeviceadvisor.model.GetEndpointResponse.ReadOnly
    ] = asyncRequestResponse[GetEndpointRequest, GetEndpointResponse](
      "getEndpoint",
      api.getEndpoint
    )(request.buildAwsValue())
      .map(zio.aws.iotdeviceadvisor.model.GetEndpointResponse.wrap)
      .provideEnvironment(r)
    def updateSuiteDefinition(
        request: zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest
    ): IO[
      AwsError,
      zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateSuiteDefinitionRequest,
      UpdateSuiteDefinitionResponse
    ]("updateSuiteDefinition", api.updateSuiteDefinition)(
      request.buildAwsValue()
    ).map(zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse.wrap)
      .provideEnvironment(r)
    def listSuiteRuns(
        request: zio.aws.iotdeviceadvisor.model.ListSuiteRunsRequest
    ): IO[
      AwsError,
      zio.aws.iotdeviceadvisor.model.ListSuiteRunsResponse.ReadOnly
    ] = asyncRequestResponse[ListSuiteRunsRequest, ListSuiteRunsResponse](
      "listSuiteRuns",
      api.listSuiteRuns
    )(request.buildAwsValue())
      .map(zio.aws.iotdeviceadvisor.model.ListSuiteRunsResponse.wrap)
      .provideEnvironment(r)
    def listSuiteDefinitions(
        request: zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsRequest
    ): IO[
      AwsError,
      zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSuiteDefinitionsRequest,
      ListSuiteDefinitionsResponse
    ]("listSuiteDefinitions", api.listSuiteDefinitions)(request.buildAwsValue())
      .map(zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsResponse.wrap)
      .provideEnvironment(r)
    def stopSuiteRun(
        request: zio.aws.iotdeviceadvisor.model.StopSuiteRunRequest
    ): IO[
      AwsError,
      zio.aws.iotdeviceadvisor.model.StopSuiteRunResponse.ReadOnly
    ] = asyncRequestResponse[StopSuiteRunRequest, StopSuiteRunResponse](
      "stopSuiteRun",
      api.stopSuiteRun
    )(request.buildAwsValue())
      .map(zio.aws.iotdeviceadvisor.model.StopSuiteRunResponse.wrap)
      .provideEnvironment(r)
    def getSuiteDefinition(
        request: zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionRequest
    ): IO[
      AwsError,
      zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetSuiteDefinitionRequest,
      GetSuiteDefinitionResponse
    ]("getSuiteDefinition", api.getSuiteDefinition)(request.buildAwsValue())
      .map(zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.iotdeviceadvisor.model.UntagResourceRequest
    ): IO[
      AwsError,
      zio.aws.iotdeviceadvisor.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
      "untagResource",
      api.untagResource
    )(request.buildAwsValue())
      .map(zio.aws.iotdeviceadvisor.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def getSuiteRun(
        request: zio.aws.iotdeviceadvisor.model.GetSuiteRunRequest
    ): IO[
      AwsError,
      zio.aws.iotdeviceadvisor.model.GetSuiteRunResponse.ReadOnly
    ] = asyncRequestResponse[GetSuiteRunRequest, GetSuiteRunResponse](
      "getSuiteRun",
      api.getSuiteRun
    )(request.buildAwsValue())
      .map(zio.aws.iotdeviceadvisor.model.GetSuiteRunResponse.wrap)
      .provideEnvironment(r)
    def deleteSuiteDefinition(
        request: zio.aws.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest
    ): IO[
      AwsError,
      zio.aws.iotdeviceadvisor.model.DeleteSuiteDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteSuiteDefinitionRequest,
      DeleteSuiteDefinitionResponse
    ]("deleteSuiteDefinition", api.deleteSuiteDefinition)(
      request.buildAwsValue()
    ).map(zio.aws.iotdeviceadvisor.model.DeleteSuiteDefinitionResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.iotdeviceadvisor.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.iotdeviceadvisor.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.iotdeviceadvisor.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.iotdeviceadvisor.model.TagResourceRequest
    ): IO[
      AwsError,
      zio.aws.iotdeviceadvisor.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[TagResourceRequest, TagResourceResponse](
      "tagResource",
      api.tagResource
    )(request.buildAwsValue())
      .map(zio.aws.iotdeviceadvisor.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def getSuiteRunReport(
        request: zio.aws.iotdeviceadvisor.model.GetSuiteRunReportRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[GetSuiteRunReportRequest, GetSuiteRunReportResponse](
        "getSuiteRunReport",
        api.getSuiteRunReport
      )(request.buildAwsValue())
        .map(zio.aws.iotdeviceadvisor.model.GetSuiteRunReportResponse.wrap)
        .provideEnvironment(r)
    def startSuiteRun(
        request: zio.aws.iotdeviceadvisor.model.StartSuiteRunRequest
    ): IO[
      AwsError,
      zio.aws.iotdeviceadvisor.model.StartSuiteRunResponse.ReadOnly
    ] = asyncRequestResponse[StartSuiteRunRequest, StartSuiteRunResponse](
      "startSuiteRun",
      api.startSuiteRun
    )(request.buildAwsValue())
      .map(zio.aws.iotdeviceadvisor.model.StartSuiteRunResponse.wrap)
      .provideEnvironment(r)
    def createSuiteDefinition(
        request: zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionRequest
    ): IO[
      AwsError,
      zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateSuiteDefinitionRequest,
      CreateSuiteDefinitionResponse
    ]("createSuiteDefinition", api.createSuiteDefinition)(
      request.buildAwsValue()
    ).map(zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionResponse.wrap)
      .provideEnvironment(r)
  }
  def getEndpoint(
      request: zio.aws.iotdeviceadvisor.model.GetEndpointRequest
  ): ZIO[
    zio.aws.iotdeviceadvisor.IotDeviceAdvisor,
    AwsError,
    zio.aws.iotdeviceadvisor.model.GetEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEndpoint(request))
  def updateSuiteDefinition(
      request: zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest
  ): ZIO[
    zio.aws.iotdeviceadvisor.IotDeviceAdvisor,
    AwsError,
    zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSuiteDefinition(request))
  def listSuiteRuns(
      request: zio.aws.iotdeviceadvisor.model.ListSuiteRunsRequest
  ): ZIO[
    zio.aws.iotdeviceadvisor.IotDeviceAdvisor,
    AwsError,
    zio.aws.iotdeviceadvisor.model.ListSuiteRunsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSuiteRuns(request))
  def listSuiteDefinitions(
      request: zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsRequest
  ): ZIO[
    zio.aws.iotdeviceadvisor.IotDeviceAdvisor,
    AwsError,
    zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSuiteDefinitions(request))
  def stopSuiteRun(
      request: zio.aws.iotdeviceadvisor.model.StopSuiteRunRequest
  ): ZIO[
    zio.aws.iotdeviceadvisor.IotDeviceAdvisor,
    AwsError,
    zio.aws.iotdeviceadvisor.model.StopSuiteRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopSuiteRun(request))
  def getSuiteDefinition(
      request: zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionRequest
  ): ZIO[
    zio.aws.iotdeviceadvisor.IotDeviceAdvisor,
    AwsError,
    zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSuiteDefinition(request))
  def untagResource(
      request: zio.aws.iotdeviceadvisor.model.UntagResourceRequest
  ): ZIO[
    zio.aws.iotdeviceadvisor.IotDeviceAdvisor,
    AwsError,
    zio.aws.iotdeviceadvisor.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getSuiteRun(
      request: zio.aws.iotdeviceadvisor.model.GetSuiteRunRequest
  ): ZIO[
    zio.aws.iotdeviceadvisor.IotDeviceAdvisor,
    AwsError,
    zio.aws.iotdeviceadvisor.model.GetSuiteRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSuiteRun(request))
  def deleteSuiteDefinition(
      request: zio.aws.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest
  ): ZIO[
    zio.aws.iotdeviceadvisor.IotDeviceAdvisor,
    AwsError,
    zio.aws.iotdeviceadvisor.model.DeleteSuiteDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSuiteDefinition(request))
  def listTagsForResource(
      request: zio.aws.iotdeviceadvisor.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.iotdeviceadvisor.IotDeviceAdvisor,
    AwsError,
    zio.aws.iotdeviceadvisor.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(
      request: zio.aws.iotdeviceadvisor.model.TagResourceRequest
  ): ZIO[
    zio.aws.iotdeviceadvisor.IotDeviceAdvisor,
    AwsError,
    zio.aws.iotdeviceadvisor.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getSuiteRunReport(
      request: zio.aws.iotdeviceadvisor.model.GetSuiteRunReportRequest
  ): ZIO[zio.aws.iotdeviceadvisor.IotDeviceAdvisor, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getSuiteRunReport(request))
  def startSuiteRun(
      request: zio.aws.iotdeviceadvisor.model.StartSuiteRunRequest
  ): ZIO[
    zio.aws.iotdeviceadvisor.IotDeviceAdvisor,
    AwsError,
    zio.aws.iotdeviceadvisor.model.StartSuiteRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startSuiteRun(request))
  def createSuiteDefinition(
      request: zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionRequest
  ): ZIO[
    zio.aws.iotdeviceadvisor.IotDeviceAdvisor,
    AwsError,
    zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSuiteDefinition(request))
}
