package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotdeviceadvisor.model.primitives.{
  SuiteDefinitionName,
  IntendedForQualificationBoolean,
  IsLongDurationTestBoolean,
  RootGroup,
  AmazonResourceName
}
import scala.jdk.CollectionConverters._
final case class SuiteDefinitionConfiguration(
    suiteDefinitionName: Optional[SuiteDefinitionName] = Optional.Absent,
    devices: Optional[
      Iterable[zio.aws.iotdeviceadvisor.model.DeviceUnderTest]
    ] = Optional.Absent,
    intendedForQualification: Optional[IntendedForQualificationBoolean] =
      Optional.Absent,
    isLongDurationTest: Optional[IsLongDurationTestBoolean] = Optional.Absent,
    rootGroup: Optional[RootGroup] = Optional.Absent,
    devicePermissionRoleArn: Optional[AmazonResourceName] = Optional.Absent,
    protocol: Optional[zio.aws.iotdeviceadvisor.model.Protocol] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionConfiguration = {
    import SuiteDefinitionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionConfiguration
      .builder()
      .optionallyWith(
        suiteDefinitionName.map(value =>
          SuiteDefinitionName.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionName)
      .optionallyWith(
        devices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.devices)
      .optionallyWith(
        intendedForQualification.map(value =>
          IntendedForQualificationBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.intendedForQualification)
      .optionallyWith(
        isLongDurationTest.map(value =>
          IsLongDurationTestBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.isLongDurationTest)
      .optionallyWith(
        rootGroup.map(value => RootGroup.unwrap(value): java.lang.String)
      )(_.rootGroup)
      .optionallyWith(
        devicePermissionRoleArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.devicePermissionRoleArn)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly =
    zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration
      .wrap(buildAwsValue())
}
object SuiteDefinitionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration =
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration(
        suiteDefinitionName.map(value => value),
        devices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        intendedForQualification.map(value => value),
        isLongDurationTest.map(value => value),
        rootGroup.map(value => value),
        devicePermissionRoleArn.map(value => value),
        protocol.map(value => value)
      )
    def suiteDefinitionName: Optional[SuiteDefinitionName]
    def devices: Optional[
      List[zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly]
    ]
    def intendedForQualification: Optional[IntendedForQualificationBoolean]
    def isLongDurationTest: Optional[IsLongDurationTestBoolean]
    def rootGroup: Optional[RootGroup]
    def devicePermissionRoleArn: Optional[AmazonResourceName]
    def protocol: Optional[zio.aws.iotdeviceadvisor.model.Protocol]
    def getSuiteDefinitionName: ZIO[Any, AwsError, SuiteDefinitionName] =
      AwsError.unwrapOptionField("suiteDefinitionName", suiteDefinitionName)
    def getDevices: ZIO[Any, AwsError, List[
      zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly
    ]] = AwsError.unwrapOptionField("devices", devices)
    def getIntendedForQualification
        : ZIO[Any, AwsError, IntendedForQualificationBoolean] = AwsError
      .unwrapOptionField("intendedForQualification", intendedForQualification)
    def getIsLongDurationTest: ZIO[Any, AwsError, IsLongDurationTestBoolean] =
      AwsError.unwrapOptionField("isLongDurationTest", isLongDurationTest)
    def getRootGroup: ZIO[Any, AwsError, RootGroup] =
      AwsError.unwrapOptionField("rootGroup", rootGroup)
    def getDevicePermissionRoleArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField(
        "devicePermissionRoleArn",
        devicePermissionRoleArn
      )
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.iotdeviceadvisor.model.Protocol] =
      AwsError.unwrapOptionField("protocol", protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionConfiguration
  ) extends zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly {
    override val suiteDefinitionName: Optional[SuiteDefinitionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suiteDefinitionName())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives.SuiteDefinitionName(value)
        )
    override val devices: Optional[
      List[zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.devices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotdeviceadvisor.model.DeviceUnderTest.wrap(item)
        }.toList
      )
    override val intendedForQualification
        : Optional[IntendedForQualificationBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.intendedForQualification())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives
          .IntendedForQualificationBoolean(value)
      )
    override val isLongDurationTest: Optional[IsLongDurationTestBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isLongDurationTest())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives
            .IsLongDurationTestBoolean(value)
        )
    override val rootGroup: Optional[RootGroup] = zio.aws.core.internal
      .optionalFromNullable(impl.rootGroup())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.RootGroup(value))
    override val devicePermissionRoleArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.devicePermissionRoleArn())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName(value)
        )
    override val protocol: Optional[zio.aws.iotdeviceadvisor.model.Protocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.iotdeviceadvisor.model.Protocol.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionConfiguration
  ): zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly =
    new Wrapper(impl)
}
