package zio.aws.iotdeviceadvisor.model
import scala.jdk.CollectionConverters._
sealed trait Protocol {
  def unwrap: software.amazon.awssdk.services.iotdeviceadvisor.model.Protocol
}
object Protocol {
  def wrap(
      value: software.amazon.awssdk.services.iotdeviceadvisor.model.Protocol
  ): zio.aws.iotdeviceadvisor.model.Protocol = value match {
    case software.amazon.awssdk.services.iotdeviceadvisor.model.Protocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.Protocol.MQTT_V3_1_1 =>
      val r = MqttV3_1_1
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.Protocol.MQTT_V5 =>
      val r = MqttV5
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotdeviceadvisor.model.Protocol {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.Protocol =
      software.amazon.awssdk.services.iotdeviceadvisor.model.Protocol.UNKNOWN_TO_SDK_VERSION
  }
  case object MqttV3_1_1 extends zio.aws.iotdeviceadvisor.model.Protocol {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.Protocol =
      software.amazon.awssdk.services.iotdeviceadvisor.model.Protocol.MQTT_V3_1_1
  }
  case object MqttV5 extends zio.aws.iotdeviceadvisor.model.Protocol {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.Protocol =
      software.amazon.awssdk.services.iotdeviceadvisor.model.Protocol.MQTT_V5
  }
}
