package zio.aws.iotdeviceadvisor.model
import zio.aws.iotdeviceadvisor.model.primitives.{
  Timestamp,
  AmazonResourceName,
  UUID,
  SuiteDefinitionVersion,
  String128,
  String256
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetSuiteDefinitionResponse(
    suiteDefinitionId: Optional[UUID] = Optional.Absent,
    suiteDefinitionArn: Optional[AmazonResourceName] = Optional.Absent,
    suiteDefinitionVersion: Optional[SuiteDefinitionVersion] = Optional.Absent,
    latestVersion: Optional[SuiteDefinitionVersion] = Optional.Absent,
    suiteDefinitionConfiguration: Optional[
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration
    ] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    lastModifiedAt: Optional[Timestamp] = Optional.Absent,
    tags: Optional[Map[String128, String256]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionResponse = {
    import GetSuiteDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionResponse
      .builder()
      .optionallyWith(
        suiteDefinitionId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.suiteDefinitionId)
      .optionallyWith(
        suiteDefinitionArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionArn)
      .optionallyWith(
        suiteDefinitionVersion.map(value =>
          SuiteDefinitionVersion.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionVersion)
      .optionallyWith(
        latestVersion.map(value =>
          SuiteDefinitionVersion.unwrap(value): java.lang.String
        )
      )(_.latestVersion)
      .optionallyWith(
        suiteDefinitionConfiguration.map(value => value.buildAwsValue())
      )(_.suiteDefinitionConfiguration)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastModifiedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedAt)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (String128.unwrap(key): java.lang.String) -> (String256
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionResponse.ReadOnly =
    zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionResponse
      .wrap(buildAwsValue())
}
object GetSuiteDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionResponse =
      zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionResponse(
        suiteDefinitionId.map(value => value),
        suiteDefinitionArn.map(value => value),
        suiteDefinitionVersion.map(value => value),
        latestVersion.map(value => value),
        suiteDefinitionConfiguration.map(value => value.asEditable),
        createdAt.map(value => value),
        lastModifiedAt.map(value => value),
        tags.map(value => value)
      )
    def suiteDefinitionId: Optional[UUID]
    def suiteDefinitionArn: Optional[AmazonResourceName]
    def suiteDefinitionVersion: Optional[SuiteDefinitionVersion]
    def latestVersion: Optional[SuiteDefinitionVersion]
    def suiteDefinitionConfiguration: Optional[
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly
    ]
    def createdAt: Optional[Timestamp]
    def lastModifiedAt: Optional[Timestamp]
    def tags: Optional[Map[String128, String256]]
    def getSuiteDefinitionId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("suiteDefinitionId", suiteDefinitionId)
    def getSuiteDefinitionArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("suiteDefinitionArn", suiteDefinitionArn)
    def getSuiteDefinitionVersion: ZIO[Any, AwsError, SuiteDefinitionVersion] =
      AwsError.unwrapOptionField(
        "suiteDefinitionVersion",
        suiteDefinitionVersion
      )
    def getLatestVersion: ZIO[Any, AwsError, SuiteDefinitionVersion] =
      AwsError.unwrapOptionField("latestVersion", latestVersion)
    def getSuiteDefinitionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "suiteDefinitionConfiguration",
      suiteDefinitionConfiguration
    )
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastModifiedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedAt", lastModifiedAt)
    def getTags: ZIO[Any, AwsError, Map[String128, String256]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionResponse
  ) extends zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionResponse.ReadOnly {
    override val suiteDefinitionId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.suiteDefinitionId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val suiteDefinitionArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suiteDefinitionArn())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName(value)
        )
    override val suiteDefinitionVersion: Optional[SuiteDefinitionVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suiteDefinitionVersion())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives
            .SuiteDefinitionVersion(value)
        )
    override val latestVersion: Optional[SuiteDefinitionVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestVersion())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives
            .SuiteDefinitionVersion(value)
        )
    override val suiteDefinitionConfiguration: Optional[
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.suiteDefinitionConfiguration())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.wrap(value)
      )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
    override val lastModifiedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedAt())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
    override val tags: Optional[Map[String128, String256]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iotdeviceadvisor.model.primitives.String128(
                key
              ) -> zio.aws.iotdeviceadvisor.model.primitives.String256(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionResponse
  ): zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
