package zio.aws.iotdeviceadvisor.model
import zio.aws.iotdeviceadvisor.model.primitives.{
  Warnings,
  Timestamp,
  Failure,
  UUID,
  TestCaseDefinitionName,
  LogUrl
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class TestCaseRun(
    testCaseRunId: Optional[UUID] = Optional.Absent,
    testCaseDefinitionId: Optional[UUID] = Optional.Absent,
    testCaseDefinitionName: Optional[TestCaseDefinitionName] = Optional.Absent,
    status: Optional[zio.aws.iotdeviceadvisor.model.Status] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    logUrl: Optional[LogUrl] = Optional.Absent,
    warnings: Optional[Warnings] = Optional.Absent,
    failure: Optional[Failure] = Optional.Absent,
    testScenarios: Optional[
      Iterable[zio.aws.iotdeviceadvisor.model.TestCaseScenario]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseRun = {
    import TestCaseRun.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseRun
      .builder()
      .optionallyWith(
        testCaseRunId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.testCaseRunId)
      .optionallyWith(
        testCaseDefinitionId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.testCaseDefinitionId)
      .optionallyWith(
        testCaseDefinitionName.map(value =>
          TestCaseDefinitionName.unwrap(value): java.lang.String
        )
      )(_.testCaseDefinitionName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        logUrl.map(value => LogUrl.unwrap(value): java.lang.String)
      )(_.logUrl)
      .optionallyWith(
        warnings.map(value => Warnings.unwrap(value): java.lang.String)
      )(_.warnings)
      .optionallyWith(
        failure.map(value => Failure.unwrap(value): java.lang.String)
      )(_.failure)
      .optionallyWith(
        testScenarios.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.testScenarios)
      .build()
  }
  def asReadOnly: zio.aws.iotdeviceadvisor.model.TestCaseRun.ReadOnly =
    zio.aws.iotdeviceadvisor.model.TestCaseRun.wrap(buildAwsValue())
}
object TestCaseRun {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseRun
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.TestCaseRun =
      zio.aws.iotdeviceadvisor.model.TestCaseRun(
        testCaseRunId.map(value => value),
        testCaseDefinitionId.map(value => value),
        testCaseDefinitionName.map(value => value),
        status.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        logUrl.map(value => value),
        warnings.map(value => value),
        failure.map(value => value),
        testScenarios.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def testCaseRunId: Optional[UUID]
    def testCaseDefinitionId: Optional[UUID]
    def testCaseDefinitionName: Optional[TestCaseDefinitionName]
    def status: Optional[zio.aws.iotdeviceadvisor.model.Status]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def logUrl: Optional[LogUrl]
    def warnings: Optional[Warnings]
    def failure: Optional[Failure]
    def testScenarios: Optional[
      List[zio.aws.iotdeviceadvisor.model.TestCaseScenario.ReadOnly]
    ]
    def getTestCaseRunId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("testCaseRunId", testCaseRunId)
    def getTestCaseDefinitionId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("testCaseDefinitionId", testCaseDefinitionId)
    def getTestCaseDefinitionName: ZIO[Any, AwsError, TestCaseDefinitionName] =
      AwsError.unwrapOptionField(
        "testCaseDefinitionName",
        testCaseDefinitionName
      )
    def getStatus: ZIO[Any, AwsError, zio.aws.iotdeviceadvisor.model.Status] =
      AwsError.unwrapOptionField("status", status)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getLogUrl: ZIO[Any, AwsError, LogUrl] =
      AwsError.unwrapOptionField("logUrl", logUrl)
    def getWarnings: ZIO[Any, AwsError, Warnings] =
      AwsError.unwrapOptionField("warnings", warnings)
    def getFailure: ZIO[Any, AwsError, Failure] =
      AwsError.unwrapOptionField("failure", failure)
    def getTestScenarios: ZIO[Any, AwsError, List[
      zio.aws.iotdeviceadvisor.model.TestCaseScenario.ReadOnly
    ]] = AwsError.unwrapOptionField("testScenarios", testScenarios)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseRun
  ) extends zio.aws.iotdeviceadvisor.model.TestCaseRun.ReadOnly {
    override val testCaseRunId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.testCaseRunId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val testCaseDefinitionId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.testCaseDefinitionId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val testCaseDefinitionName: Optional[TestCaseDefinitionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testCaseDefinitionName())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives
            .TestCaseDefinitionName(value)
        )
    override val status: Optional[zio.aws.iotdeviceadvisor.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotdeviceadvisor.model.Status.wrap(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
    override val logUrl: Optional[LogUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.logUrl())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.LogUrl(value))
    override val warnings: Optional[Warnings] = zio.aws.core.internal
      .optionalFromNullable(impl.warnings())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Warnings(value))
    override val failure: Optional[Failure] = zio.aws.core.internal
      .optionalFromNullable(impl.failure())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Failure(value))
    override val testScenarios: Optional[
      List[zio.aws.iotdeviceadvisor.model.TestCaseScenario.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.testScenarios())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotdeviceadvisor.model.TestCaseScenario.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseRun
  ): zio.aws.iotdeviceadvisor.model.TestCaseRun.ReadOnly = new Wrapper(impl)
}
