package zio.aws.iotdeviceadvisor.model
import zio.aws.iotdeviceadvisor.model.primitives.{
  SuiteDefinitionName,
  Timestamp,
  AmazonResourceName,
  UUID,
  SuiteDefinitionVersion
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class UpdateSuiteDefinitionResponse(
    suiteDefinitionId: Optional[UUID] = Optional.Absent,
    suiteDefinitionArn: Optional[AmazonResourceName] = Optional.Absent,
    suiteDefinitionName: Optional[SuiteDefinitionName] = Optional.Absent,
    suiteDefinitionVersion: Optional[SuiteDefinitionVersion] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse = {
    import UpdateSuiteDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse
      .builder()
      .optionallyWith(
        suiteDefinitionId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.suiteDefinitionId)
      .optionallyWith(
        suiteDefinitionArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionArn)
      .optionallyWith(
        suiteDefinitionName.map(value =>
          SuiteDefinitionName.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionName)
      .optionallyWith(
        suiteDefinitionVersion.map(value =>
          SuiteDefinitionVersion.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionVersion)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse.ReadOnly =
    zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse
      .wrap(buildAwsValue())
}
object UpdateSuiteDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse =
      zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse(
        suiteDefinitionId.map(value => value),
        suiteDefinitionArn.map(value => value),
        suiteDefinitionName.map(value => value),
        suiteDefinitionVersion.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value)
      )
    def suiteDefinitionId: Optional[UUID]
    def suiteDefinitionArn: Optional[AmazonResourceName]
    def suiteDefinitionName: Optional[SuiteDefinitionName]
    def suiteDefinitionVersion: Optional[SuiteDefinitionVersion]
    def createdAt: Optional[Timestamp]
    def lastUpdatedAt: Optional[Timestamp]
    def getSuiteDefinitionId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("suiteDefinitionId", suiteDefinitionId)
    def getSuiteDefinitionArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("suiteDefinitionArn", suiteDefinitionArn)
    def getSuiteDefinitionName: ZIO[Any, AwsError, SuiteDefinitionName] =
      AwsError.unwrapOptionField("suiteDefinitionName", suiteDefinitionName)
    def getSuiteDefinitionVersion: ZIO[Any, AwsError, SuiteDefinitionVersion] =
      AwsError.unwrapOptionField(
        "suiteDefinitionVersion",
        suiteDefinitionVersion
      )
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse
  ) extends zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse.ReadOnly {
    override val suiteDefinitionId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.suiteDefinitionId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val suiteDefinitionArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suiteDefinitionArn())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName(value)
        )
    override val suiteDefinitionName: Optional[SuiteDefinitionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suiteDefinitionName())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives.SuiteDefinitionName(value)
        )
    override val suiteDefinitionVersion: Optional[SuiteDefinitionVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suiteDefinitionVersion())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives
            .SuiteDefinitionVersion(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse
  ): zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
