package zio.aws.iotdeviceadvisor.model
import zio.aws.iotdeviceadvisor.model.primitives.{
  Timestamp,
  IntendedForQualificationBoolean,
  SuiteDefinitionName,
  UUID
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class SuiteDefinitionInformation(
    suiteDefinitionId: Optional[UUID] = Optional.Absent,
    suiteDefinitionName: Optional[SuiteDefinitionName] = Optional.Absent,
    defaultDevices: Optional[
      Iterable[zio.aws.iotdeviceadvisor.model.DeviceUnderTest]
    ] = Optional.Absent,
    intendedForQualification: Optional[IntendedForQualificationBoolean] =
      Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionInformation = {
    import SuiteDefinitionInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionInformation
      .builder()
      .optionallyWith(
        suiteDefinitionId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.suiteDefinitionId)
      .optionallyWith(
        suiteDefinitionName.map(value =>
          SuiteDefinitionName.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionName)
      .optionallyWith(
        defaultDevices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.defaultDevices)
      .optionallyWith(
        intendedForQualification.map(value =>
          IntendedForQualificationBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.intendedForQualification)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation.ReadOnly =
    zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation
      .wrap(buildAwsValue())
}
object SuiteDefinitionInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation =
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation(
        suiteDefinitionId.map(value => value),
        suiteDefinitionName.map(value => value),
        defaultDevices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        intendedForQualification.map(value => value),
        createdAt.map(value => value)
      )
    def suiteDefinitionId: Optional[UUID]
    def suiteDefinitionName: Optional[SuiteDefinitionName]
    def defaultDevices: Optional[
      List[zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly]
    ]
    def intendedForQualification: Optional[IntendedForQualificationBoolean]
    def createdAt: Optional[Timestamp]
    def getSuiteDefinitionId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("suiteDefinitionId", suiteDefinitionId)
    def getSuiteDefinitionName: ZIO[Any, AwsError, SuiteDefinitionName] =
      AwsError.unwrapOptionField("suiteDefinitionName", suiteDefinitionName)
    def getDefaultDevices: ZIO[Any, AwsError, List[
      zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly
    ]] = AwsError.unwrapOptionField("defaultDevices", defaultDevices)
    def getIntendedForQualification
        : ZIO[Any, AwsError, IntendedForQualificationBoolean] = AwsError
      .unwrapOptionField("intendedForQualification", intendedForQualification)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionInformation
  ) extends zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation.ReadOnly {
    override val suiteDefinitionId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.suiteDefinitionId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val suiteDefinitionName: Optional[SuiteDefinitionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suiteDefinitionName())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives.SuiteDefinitionName(value)
        )
    override val defaultDevices: Optional[
      List[zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultDevices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotdeviceadvisor.model.DeviceUnderTest.wrap(item)
        }.toList
      )
    override val intendedForQualification
        : Optional[IntendedForQualificationBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.intendedForQualification())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives
          .IntendedForQualificationBoolean(value)
      )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionInformation
  ): zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation.ReadOnly =
    new Wrapper(impl)
}
