package zio.aws.iotdeviceadvisor.model
import zio.aws.iotdeviceadvisor.model.primitives.{
  Timestamp,
  AmazonResourceName,
  UUID
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class StartSuiteRunResponse(
    suiteRunId: Optional[UUID] = Optional.Absent,
    suiteRunArn: Optional[AmazonResourceName] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.StartSuiteRunResponse = {
    import StartSuiteRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.StartSuiteRunResponse
      .builder()
      .optionallyWith(
        suiteRunId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.suiteRunId)
      .optionallyWith(
        suiteRunArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.suiteRunArn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.StartSuiteRunResponse.ReadOnly =
    zio.aws.iotdeviceadvisor.model.StartSuiteRunResponse.wrap(buildAwsValue())
}
object StartSuiteRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.StartSuiteRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.StartSuiteRunResponse =
      zio.aws.iotdeviceadvisor.model.StartSuiteRunResponse(
        suiteRunId.map(value => value),
        suiteRunArn.map(value => value),
        createdAt.map(value => value)
      )
    def suiteRunId: Optional[UUID]
    def suiteRunArn: Optional[AmazonResourceName]
    def createdAt: Optional[Timestamp]
    def getSuiteRunId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("suiteRunId", suiteRunId)
    def getSuiteRunArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("suiteRunArn", suiteRunArn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.StartSuiteRunResponse
  ) extends zio.aws.iotdeviceadvisor.model.StartSuiteRunResponse.ReadOnly {
    override val suiteRunId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.suiteRunId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val suiteRunArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suiteRunArn())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.StartSuiteRunResponse
  ): zio.aws.iotdeviceadvisor.model.StartSuiteRunResponse.ReadOnly =
    new Wrapper(impl)
}
