package zio.aws.iotdeviceadvisor
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.iotdeviceadvisor.model.primitives.GroupName.Type
import zio.aws.iotdeviceadvisor.model.primitives.{String256, String128, UUID}
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName.Type
    object Endpoint extends Subtype[String]
    type Endpoint = zio.aws.iotdeviceadvisor.model.primitives.Endpoint.Type
    object ErrorReason extends Subtype[String]
    type ErrorReason =
      zio.aws.iotdeviceadvisor.model.primitives.ErrorReason.Type
    object Failure extends Subtype[String]
    type Failure = zio.aws.iotdeviceadvisor.model.primitives.Failure.Type
    object GroupName extends Subtype[String]
    type GroupName = zio.aws.iotdeviceadvisor.model.primitives.GroupName.Type
    object IntendedForQualificationBoolean extends Subtype[Boolean]
    type IntendedForQualificationBoolean =
      zio.aws.iotdeviceadvisor.model.primitives.IntendedForQualificationBoolean.Type
    object LogUrl extends Subtype[String]
    type LogUrl = zio.aws.iotdeviceadvisor.model.primitives.LogUrl.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.iotdeviceadvisor.model.primitives.MaxResults.Type
    object ParallelRun extends Subtype[Boolean]
    type ParallelRun =
      zio.aws.iotdeviceadvisor.model.primitives.ParallelRun.Type
    object QualificationReportDownloadUrl extends Subtype[String]
    type QualificationReportDownloadUrl =
      zio.aws.iotdeviceadvisor.model.primitives.QualificationReportDownloadUrl.Type
    object RootGroup extends Subtype[String]
    type RootGroup = zio.aws.iotdeviceadvisor.model.primitives.RootGroup.Type
    object String128 extends Subtype[String]
    type String128 = zio.aws.iotdeviceadvisor.model.primitives.String128.Type
    object String256 extends Subtype[String]
    type String256 = zio.aws.iotdeviceadvisor.model.primitives.String256.Type
    object SuiteDefinitionName extends Subtype[String]
    type SuiteDefinitionName =
      zio.aws.iotdeviceadvisor.model.primitives.SuiteDefinitionName.Type
    object SuiteDefinitionVersion extends Subtype[String]
    type SuiteDefinitionVersion =
      zio.aws.iotdeviceadvisor.model.primitives.SuiteDefinitionVersion.Type
    object SuiteRunResultCount extends Subtype[Int]
    type SuiteRunResultCount =
      zio.aws.iotdeviceadvisor.model.primitives.SuiteRunResultCount.Type
    object TestCaseDefinitionName extends Subtype[String]
    type TestCaseDefinitionName =
      zio.aws.iotdeviceadvisor.model.primitives.TestCaseDefinitionName.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.iotdeviceadvisor.model.primitives.Timestamp.Type
    object Token extends Subtype[String]
    type Token = zio.aws.iotdeviceadvisor.model.primitives.Token.Type
    object UUID extends Subtype[String]
    type UUID = zio.aws.iotdeviceadvisor.model.primitives.UUID.Type
    object Warnings extends Subtype[String]
    type Warnings = zio.aws.iotdeviceadvisor.model.primitives.Warnings.Type
  }
  type DeviceUnderTestList =
    List[zio.aws.iotdeviceadvisor.model.DeviceUnderTest]
  type GroupResultList = List[zio.aws.iotdeviceadvisor.model.GroupResult]
  type SelectedTestList = List[UUID]
  type SuiteDefinitionInformationList =
    List[zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation]
  type SuiteRunsList = List[zio.aws.iotdeviceadvisor.model.SuiteRunInformation]
  type TagKeyList = List[String128]
  type TagMap = Map[String128, String256]
  type TestCaseRuns = List[zio.aws.iotdeviceadvisor.model.TestCaseRun]
}
