package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotdeviceadvisor.model.primitives.UUID
import scala.jdk.CollectionConverters._
final case class DeleteSuiteDefinitionRequest(suiteDefinitionId: UUID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest = {
    import DeleteSuiteDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest
      .builder()
      .suiteDefinitionId(UUID.unwrap(suiteDefinitionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest.ReadOnly =
    zio.aws.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest
      .wrap(buildAwsValue())
}
object DeleteSuiteDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest =
      zio.aws.iotdeviceadvisor.model
        .DeleteSuiteDefinitionRequest(suiteDefinitionId)
    def suiteDefinitionId: UUID
    def getSuiteDefinitionId: ZIO[Any, Nothing, UUID] =
      ZIO.succeed(suiteDefinitionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest
  ) extends zio.aws.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest.ReadOnly {
    override val suiteDefinitionId: UUID =
      zio.aws.iotdeviceadvisor.model.primitives.UUID(impl.suiteDefinitionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest
  ): zio.aws.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
