package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotdeviceadvisor.model.primitives.Endpoint
import scala.jdk.CollectionConverters._
final case class GetEndpointResponse(
    endpoint: Optional[Endpoint] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointResponse = {
    import GetEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointResponse
      .builder()
      .optionallyWith(
        endpoint.map(value => Endpoint.unwrap(value): java.lang.String)
      )(_.endpoint)
      .build()
  }
  def asReadOnly: zio.aws.iotdeviceadvisor.model.GetEndpointResponse.ReadOnly =
    zio.aws.iotdeviceadvisor.model.GetEndpointResponse.wrap(buildAwsValue())
}
object GetEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.GetEndpointResponse =
      zio.aws.iotdeviceadvisor.model
        .GetEndpointResponse(endpoint.map(value => value))
    def endpoint: Optional[Endpoint]
    def getEndpoint: ZIO[Any, AwsError, Endpoint] =
      AwsError.unwrapOptionField("endpoint", endpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointResponse
  ) extends zio.aws.iotdeviceadvisor.model.GetEndpointResponse.ReadOnly {
    override val endpoint: Optional[Endpoint] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Endpoint(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointResponse
  ): zio.aws.iotdeviceadvisor.model.GetEndpointResponse.ReadOnly = new Wrapper(
    impl
  )
}
