package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotdeviceadvisor.model.primitives.{String128, AmazonResourceName}
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: AmazonResourceName,
    tagKeys: Iterable[String128]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.UntagResourceRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        String128.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iotdeviceadvisor.model.UntagResourceRequest.ReadOnly =
    zio.aws.iotdeviceadvisor.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.UntagResourceRequest =
      zio.aws.iotdeviceadvisor.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: AmazonResourceName
    def tagKeys: List[String128]
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[String128]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.UntagResourceRequest
  ) extends zio.aws.iotdeviceadvisor.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.iotdeviceadvisor.model.primitives
        .AmazonResourceName(impl.resourceArn())
    override val tagKeys: List[String128] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.iotdeviceadvisor.model.primitives.String128(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.UntagResourceRequest
  ): zio.aws.iotdeviceadvisor.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
