package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotdeviceadvisor.model.primitives.{String256, String128}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    tags: Optional[Map[String128, String256]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (String128.unwrap(key): java.lang.String) -> (String256
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.iotdeviceadvisor.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.ListTagsForResourceResponse =
      zio.aws.iotdeviceadvisor.model
        .ListTagsForResourceResponse(tags.map(value => value))
    def tags: Optional[Map[String128, String256]]
    def getTags: ZIO[Any, AwsError, Map[String128, String256]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.ListTagsForResourceResponse
  ) extends zio.aws.iotdeviceadvisor.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Optional[Map[String128, String256]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iotdeviceadvisor.model.primitives.String128(
                key
              ) -> zio.aws.iotdeviceadvisor.model.primitives.String256(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.ListTagsForResourceResponse
  ): zio.aws.iotdeviceadvisor.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
