package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotdeviceadvisor.model.primitives.{GroupName, UUID}
import scala.jdk.CollectionConverters._
final case class GroupResult(
    groupId: Option[UUID] = None,
    groupName: Option[GroupName] = None,
    tests: Option[Iterable[zio.aws.iotdeviceadvisor.model.TestCaseRun]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.GroupResult = {
    import GroupResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.GroupResult
      .builder()
      .optionallyWith(
        groupId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        tests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tests)
      .build()
  }
  def asReadOnly: zio.aws.iotdeviceadvisor.model.GroupResult.ReadOnly =
    zio.aws.iotdeviceadvisor.model.GroupResult.wrap(buildAwsValue())
}
object GroupResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.GroupResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.GroupResult =
      zio.aws.iotdeviceadvisor.model.GroupResult(
        groupId.map(value => value),
        groupName.map(value => value),
        tests.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def groupId: Option[UUID]
    def groupName: Option[GroupName]
    def tests: Option[List[zio.aws.iotdeviceadvisor.model.TestCaseRun.ReadOnly]]
    def getGroupId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getTests: ZIO[Any, AwsError, List[
      zio.aws.iotdeviceadvisor.model.TestCaseRun.ReadOnly
    ]] = AwsError.unwrapOptionField("tests", tests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GroupResult
  ) extends zio.aws.iotdeviceadvisor.model.GroupResult.ReadOnly {
    override val groupId: Option[UUID] = scala
      .Option(impl.groupId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val groupName: Option[GroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.GroupName(value))
    override val tests
        : Option[List[zio.aws.iotdeviceadvisor.model.TestCaseRun.ReadOnly]] =
      scala
        .Option(impl.tests())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotdeviceadvisor.model.TestCaseRun.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GroupResult
  ): zio.aws.iotdeviceadvisor.model.GroupResult.ReadOnly = new Wrapper(impl)
}
