package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName
import scala.jdk.CollectionConverters._
final case class GetEndpointRequest(
    thingArn: Option[AmazonResourceName] = None,
    certificateArn: Option[AmazonResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointRequest = {
    import GetEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointRequest
      .builder()
      .optionallyWith(
        thingArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.thingArn)
      .optionallyWith(
        certificateArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .build()
  }
  def asReadOnly: zio.aws.iotdeviceadvisor.model.GetEndpointRequest.ReadOnly =
    zio.aws.iotdeviceadvisor.model.GetEndpointRequest.wrap(buildAwsValue())
}
object GetEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.GetEndpointRequest =
      zio.aws.iotdeviceadvisor.model.GetEndpointRequest(
        thingArn.map(value => value),
        certificateArn.map(value => value)
      )
    def thingArn: Option[AmazonResourceName]
    def certificateArn: Option[AmazonResourceName]
    def getThingArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("thingArn", thingArn)
    def getCertificateArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointRequest
  ) extends zio.aws.iotdeviceadvisor.model.GetEndpointRequest.ReadOnly {
    override val thingArn: Option[AmazonResourceName] = scala
      .Option(impl.thingArn())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName(value)
      )
    override val certificateArn: Option[AmazonResourceName] = scala
      .Option(impl.certificateArn())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GetEndpointRequest
  ): zio.aws.iotdeviceadvisor.model.GetEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
