package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotdeviceadvisor.model.primitives.{
  AmazonResourceName,
  RootGroup,
  IntendedForQualificationBoolean,
  SuiteDefinitionName
}
import scala.jdk.CollectionConverters._
final case class SuiteDefinitionConfiguration(
    suiteDefinitionName: Option[SuiteDefinitionName] = None,
    devices: Option[Iterable[zio.aws.iotdeviceadvisor.model.DeviceUnderTest]] =
      None,
    intendedForQualification: Option[IntendedForQualificationBoolean] = None,
    rootGroup: Option[RootGroup] = None,
    devicePermissionRoleArn: Option[AmazonResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionConfiguration = {
    import SuiteDefinitionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionConfiguration
      .builder()
      .optionallyWith(
        suiteDefinitionName.map(value =>
          SuiteDefinitionName.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionName)
      .optionallyWith(
        devices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.devices)
      .optionallyWith(
        intendedForQualification.map(value =>
          IntendedForQualificationBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.intendedForQualification)
      .optionallyWith(
        rootGroup.map(value => RootGroup.unwrap(value): java.lang.String)
      )(_.rootGroup)
      .optionallyWith(
        devicePermissionRoleArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.devicePermissionRoleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly =
    zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration
      .wrap(buildAwsValue())
}
object SuiteDefinitionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration =
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration(
        suiteDefinitionName.map(value => value),
        devices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        intendedForQualification.map(value => value),
        rootGroup.map(value => value),
        devicePermissionRoleArn.map(value => value)
      )
    def suiteDefinitionName: Option[SuiteDefinitionName]
    def devices
        : Option[List[zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly]]
    def intendedForQualification: Option[IntendedForQualificationBoolean]
    def rootGroup: Option[RootGroup]
    def devicePermissionRoleArn: Option[AmazonResourceName]
    def getSuiteDefinitionName: ZIO[Any, AwsError, SuiteDefinitionName] =
      AwsError.unwrapOptionField("suiteDefinitionName", suiteDefinitionName)
    def getDevices: ZIO[Any, AwsError, List[
      zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly
    ]] = AwsError.unwrapOptionField("devices", devices)
    def getIntendedForQualification
        : ZIO[Any, AwsError, IntendedForQualificationBoolean] = AwsError
      .unwrapOptionField("intendedForQualification", intendedForQualification)
    def getRootGroup: ZIO[Any, AwsError, RootGroup] =
      AwsError.unwrapOptionField("rootGroup", rootGroup)
    def getDevicePermissionRoleArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField(
        "devicePermissionRoleArn",
        devicePermissionRoleArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionConfiguration
  ) extends zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly {
    override val suiteDefinitionName: Option[SuiteDefinitionName] = scala
      .Option(impl.suiteDefinitionName())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.SuiteDefinitionName(value)
      )
    override val devices: Option[
      List[zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly]
    ] = scala
      .Option(impl.devices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotdeviceadvisor.model.DeviceUnderTest.wrap(item)
        }.toList
      )
    override val intendedForQualification
        : Option[IntendedForQualificationBoolean] = scala
      .Option(impl.intendedForQualification())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives
          .IntendedForQualificationBoolean(value)
      )
    override val rootGroup: Option[RootGroup] = scala
      .Option(impl.rootGroup())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.RootGroup(value))
    override val devicePermissionRoleArn: Option[AmazonResourceName] = scala
      .Option(impl.devicePermissionRoleArn())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionConfiguration
  ): zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly =
    new Wrapper(impl)
}
