package zio.aws.iotdeviceadvisor
import zio.aws.iotdeviceadvisor.model.GetSuiteRunReportResponse.ReadOnly
import software.amazon.awssdk.services.iotdeviceadvisor.IotDeviceAdvisorAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.iotdeviceadvisor.model.{
  GetSuiteRunReportRequest,
  StartSuiteRunRequest,
  CreateSuiteDefinitionRequest,
  ListSuiteDefinitionsRequest,
  UpdateSuiteDefinitionRequest,
  GetSuiteDefinitionRequest,
  ListTagsForResourceRequest,
  DeleteSuiteDefinitionRequest,
  GetEndpointRequest,
  ListSuiteRunsRequest,
  UntagResourceRequest,
  StopSuiteRunRequest,
  GetSuiteRunRequest,
  TagResourceRequest
}
object IotDeviceAdvisorMock extends Mock[IotDeviceAdvisor] {
  object GetEndpoint
      extends Effect[
        GetEndpointRequest,
        AwsError,
        zio.aws.iotdeviceadvisor.model.GetEndpointResponse.ReadOnly
      ]
  object UpdateSuiteDefinition
      extends Effect[
        UpdateSuiteDefinitionRequest,
        AwsError,
        zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse.ReadOnly
      ]
  object ListSuiteRuns
      extends Effect[
        ListSuiteRunsRequest,
        AwsError,
        zio.aws.iotdeviceadvisor.model.ListSuiteRunsResponse.ReadOnly
      ]
  object ListSuiteDefinitions
      extends Effect[
        ListSuiteDefinitionsRequest,
        AwsError,
        zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsResponse.ReadOnly
      ]
  object StopSuiteRun
      extends Effect[
        StopSuiteRunRequest,
        AwsError,
        zio.aws.iotdeviceadvisor.model.StopSuiteRunResponse.ReadOnly
      ]
  object GetSuiteDefinition
      extends Effect[
        GetSuiteDefinitionRequest,
        AwsError,
        zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.iotdeviceadvisor.model.UntagResourceResponse.ReadOnly
      ]
  object GetSuiteRun
      extends Effect[
        GetSuiteRunRequest,
        AwsError,
        zio.aws.iotdeviceadvisor.model.GetSuiteRunResponse.ReadOnly
      ]
  object DeleteSuiteDefinition
      extends Effect[
        DeleteSuiteDefinitionRequest,
        AwsError,
        zio.aws.iotdeviceadvisor.model.DeleteSuiteDefinitionResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.iotdeviceadvisor.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.iotdeviceadvisor.model.TagResourceResponse.ReadOnly
      ]
  object GetSuiteRunReport
      extends Effect[GetSuiteRunReportRequest, AwsError, ReadOnly]
  object StartSuiteRun
      extends Effect[
        StartSuiteRunRequest,
        AwsError,
        zio.aws.iotdeviceadvisor.model.StartSuiteRunResponse.ReadOnly
      ]
  object CreateSuiteDefinition
      extends Effect[
        CreateSuiteDefinitionRequest,
        AwsError,
        zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, IotDeviceAdvisor] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new IotDeviceAdvisor {
          val api: IotDeviceAdvisorAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : IotDeviceAdvisor = this
          def getEndpoint(request: GetEndpointRequest): IO[
            AwsError,
            zio.aws.iotdeviceadvisor.model.GetEndpointResponse.ReadOnly
          ] = proxy(GetEndpoint, request)
          def updateSuiteDefinition(request: UpdateSuiteDefinitionRequest): IO[
            AwsError,
            zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse.ReadOnly
          ] = proxy(UpdateSuiteDefinition, request)
          def listSuiteRuns(request: ListSuiteRunsRequest): IO[
            AwsError,
            zio.aws.iotdeviceadvisor.model.ListSuiteRunsResponse.ReadOnly
          ] = proxy(ListSuiteRuns, request)
          def listSuiteDefinitions(request: ListSuiteDefinitionsRequest): IO[
            AwsError,
            zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsResponse.ReadOnly
          ] = proxy(ListSuiteDefinitions, request)
          def stopSuiteRun(request: StopSuiteRunRequest): IO[
            AwsError,
            zio.aws.iotdeviceadvisor.model.StopSuiteRunResponse.ReadOnly
          ] = proxy(StopSuiteRun, request)
          def getSuiteDefinition(request: GetSuiteDefinitionRequest): IO[
            AwsError,
            zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionResponse.ReadOnly
          ] = proxy(GetSuiteDefinition, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.iotdeviceadvisor.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def getSuiteRun(request: GetSuiteRunRequest): IO[
            AwsError,
            zio.aws.iotdeviceadvisor.model.GetSuiteRunResponse.ReadOnly
          ] = proxy(GetSuiteRun, request)
          def deleteSuiteDefinition(request: DeleteSuiteDefinitionRequest): IO[
            AwsError,
            zio.aws.iotdeviceadvisor.model.DeleteSuiteDefinitionResponse.ReadOnly
          ] = proxy(DeleteSuiteDefinition, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.iotdeviceadvisor.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.iotdeviceadvisor.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def getSuiteRunReport(
              request: GetSuiteRunReportRequest
          ): IO[AwsError, ReadOnly] = proxy(GetSuiteRunReport, request)
          def startSuiteRun(request: StartSuiteRunRequest): IO[
            AwsError,
            zio.aws.iotdeviceadvisor.model.StartSuiteRunResponse.ReadOnly
          ] = proxy(StartSuiteRun, request)
          def createSuiteDefinition(request: CreateSuiteDefinitionRequest): IO[
            AwsError,
            zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionResponse.ReadOnly
          ] = proxy(CreateSuiteDefinition, request)
        }
      }
    }
    .toLayer
}
