package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotdeviceadvisor.model.primitives.QualificationReportDownloadUrl
import scala.jdk.CollectionConverters._
final case class GetSuiteRunReportResponse(
    qualificationReportDownloadUrl: Option[QualificationReportDownloadUrl] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunReportResponse = {
    import GetSuiteRunReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunReportResponse
      .builder()
      .optionallyWith(
        qualificationReportDownloadUrl.map(value =>
          QualificationReportDownloadUrl.unwrap(value): java.lang.String
        )
      )(_.qualificationReportDownloadUrl)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.GetSuiteRunReportResponse.ReadOnly =
    zio.aws.iotdeviceadvisor.model.GetSuiteRunReportResponse
      .wrap(buildAwsValue())
}
object GetSuiteRunReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.GetSuiteRunReportResponse =
      zio.aws.iotdeviceadvisor.model.GetSuiteRunReportResponse(
        qualificationReportDownloadUrl.map(value => value)
      )
    def qualificationReportDownloadUrl: Option[QualificationReportDownloadUrl]
    def getQualificationReportDownloadUrl
        : ZIO[Any, AwsError, QualificationReportDownloadUrl] =
      AwsError.unwrapOptionField(
        "qualificationReportDownloadUrl",
        qualificationReportDownloadUrl
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunReportResponse
  ) extends zio.aws.iotdeviceadvisor.model.GetSuiteRunReportResponse.ReadOnly {
    override val qualificationReportDownloadUrl
        : Option[QualificationReportDownloadUrl] = scala
      .Option(impl.qualificationReportDownloadUrl())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives
          .QualificationReportDownloadUrl(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunReportResponse
  ): zio.aws.iotdeviceadvisor.model.GetSuiteRunReportResponse.ReadOnly =
    new Wrapper(impl)
}
