package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.iotdeviceadvisor.model.primitives.{
  Timestamp,
  AmazonResourceName,
  UUID,
  SuiteDefinitionVersion,
  String128,
  String256
}
import scala.jdk.CollectionConverters._
final case class GetSuiteDefinitionResponse(
    suiteDefinitionId: Option[UUID] = None,
    suiteDefinitionArn: Option[AmazonResourceName] = None,
    suiteDefinitionVersion: Option[SuiteDefinitionVersion] = None,
    latestVersion: Option[SuiteDefinitionVersion] = None,
    suiteDefinitionConfiguration: Option[
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration
    ] = None,
    createdAt: Option[Timestamp] = None,
    lastModifiedAt: Option[Timestamp] = None,
    tags: Option[Map[String128, String256]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionResponse = {
    import GetSuiteDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionResponse
      .builder()
      .optionallyWith(
        suiteDefinitionId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.suiteDefinitionId)
      .optionallyWith(
        suiteDefinitionArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionArn)
      .optionallyWith(
        suiteDefinitionVersion.map(value =>
          SuiteDefinitionVersion.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionVersion)
      .optionallyWith(
        latestVersion.map(value =>
          SuiteDefinitionVersion.unwrap(value): java.lang.String
        )
      )(_.latestVersion)
      .optionallyWith(
        suiteDefinitionConfiguration.map(value => value.buildAwsValue())
      )(_.suiteDefinitionConfiguration)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastModifiedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedAt)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (String128.unwrap(key): java.lang.String) -> (String256
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionResponse.ReadOnly =
    zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionResponse
      .wrap(buildAwsValue())
}
object GetSuiteDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionResponse =
      zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionResponse(
        suiteDefinitionId.map(value => value),
        suiteDefinitionArn.map(value => value),
        suiteDefinitionVersion.map(value => value),
        latestVersion.map(value => value),
        suiteDefinitionConfiguration.map(value => value.asEditable),
        createdAt.map(value => value),
        lastModifiedAt.map(value => value),
        tags.map(value => value)
      )
    def suiteDefinitionId: Option[UUID]
    def suiteDefinitionArn: Option[AmazonResourceName]
    def suiteDefinitionVersion: Option[SuiteDefinitionVersion]
    def latestVersion: Option[SuiteDefinitionVersion]
    def suiteDefinitionConfiguration: Option[
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly
    ]
    def createdAt: Option[Timestamp]
    def lastModifiedAt: Option[Timestamp]
    def tags: Option[Map[String128, String256]]
    def getSuiteDefinitionId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("suiteDefinitionId", suiteDefinitionId)
    def getSuiteDefinitionArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("suiteDefinitionArn", suiteDefinitionArn)
    def getSuiteDefinitionVersion: ZIO[Any, AwsError, SuiteDefinitionVersion] =
      AwsError.unwrapOptionField(
        "suiteDefinitionVersion",
        suiteDefinitionVersion
      )
    def getLatestVersion: ZIO[Any, AwsError, SuiteDefinitionVersion] =
      AwsError.unwrapOptionField("latestVersion", latestVersion)
    def getSuiteDefinitionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "suiteDefinitionConfiguration",
      suiteDefinitionConfiguration
    )
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastModifiedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedAt", lastModifiedAt)
    def getTags: ZIO[Any, AwsError, Map[String128, String256]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionResponse
  ) extends zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionResponse.ReadOnly {
    override val suiteDefinitionId: Option[UUID] = scala
      .Option(impl.suiteDefinitionId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val suiteDefinitionArn: Option[AmazonResourceName] = scala
      .Option(impl.suiteDefinitionArn())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName(value)
      )
    override val suiteDefinitionVersion: Option[SuiteDefinitionVersion] = scala
      .Option(impl.suiteDefinitionVersion())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.SuiteDefinitionVersion(value)
      )
    override val latestVersion: Option[SuiteDefinitionVersion] = scala
      .Option(impl.latestVersion())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.SuiteDefinitionVersion(value)
      )
    override val suiteDefinitionConfiguration: Option[
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly
    ] = scala
      .Option(impl.suiteDefinitionConfiguration())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.wrap(value)
      )
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
    override val lastModifiedAt: Option[Timestamp] = scala
      .Option(impl.lastModifiedAt())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
    override val tags: Option[Map[String128, String256]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iotdeviceadvisor.model.primitives.String128(
              key
            ) -> zio.aws.iotdeviceadvisor.model.primitives.String256(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionResponse
  ): zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
