package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotdeviceadvisor.model.primitives.UUID
import scala.jdk.CollectionConverters._
final case class UpdateSuiteDefinitionRequest(
    suiteDefinitionId: UUID,
    suiteDefinitionConfiguration: Option[
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest = {
    import UpdateSuiteDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest
      .builder()
      .suiteDefinitionId(UUID.unwrap(suiteDefinitionId): java.lang.String)
      .optionallyWith(
        suiteDefinitionConfiguration.map(value => value.buildAwsValue())
      )(_.suiteDefinitionConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest.ReadOnly =
    zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest
      .wrap(buildAwsValue())
}
object UpdateSuiteDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest =
      zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest(
        suiteDefinitionId,
        suiteDefinitionConfiguration.map(value => value.asEditable)
      )
    def suiteDefinitionId: UUID
    def suiteDefinitionConfiguration: Option[
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly
    ]
    def getSuiteDefinitionId: ZIO[Any, Nothing, UUID] =
      ZIO.succeed(suiteDefinitionId)
    def getSuiteDefinitionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "suiteDefinitionConfiguration",
      suiteDefinitionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest
  ) extends zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest.ReadOnly {
    override val suiteDefinitionId: UUID =
      zio.aws.iotdeviceadvisor.model.primitives.UUID(impl.suiteDefinitionId())
    override val suiteDefinitionConfiguration: Option[
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly
    ] = scala
      .Option(impl.suiteDefinitionConfiguration())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest
  ): zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
