package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotdeviceadvisor.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListSuiteDefinitionsResponse(
    suiteDefinitionInformationList: Option[
      Iterable[zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse = {
    import ListSuiteDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse
      .builder()
      .optionallyWith(
        suiteDefinitionInformationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.suiteDefinitionInformationList)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsResponse.ReadOnly =
    zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsResponse
      .wrap(buildAwsValue())
}
object ListSuiteDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsResponse =
      zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsResponse(
        suiteDefinitionInformationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def suiteDefinitionInformationList: Option[
      List[zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation.ReadOnly]
    ]
    def nextToken: Option[Token]
    def getSuiteDefinitionInformationList: ZIO[Any, AwsError, List[
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "suiteDefinitionInformationList",
      suiteDefinitionInformationList
    )
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse
  ) extends zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsResponse.ReadOnly {
    override val suiteDefinitionInformationList: Option[
      List[zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation.ReadOnly]
    ] = scala
      .Option(impl.suiteDefinitionInformationList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse
  ): zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsResponse.ReadOnly =
    new Wrapper(impl)
}
