package zio.aws.iotdeviceadvisor.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotdeviceadvisor.model.primitives.{Token, MaxResults}
import scala.jdk.CollectionConverters._
final case class ListSuiteDefinitionsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest = {
    import ListSuiteDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsRequest.ReadOnly =
    zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsRequest
      .wrap(buildAwsValue())
}
object ListSuiteDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsRequest =
      zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[Token]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest
  ) extends zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.MaxResults(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest
  ): zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsRequest.ReadOnly =
    new Wrapper(impl)
}
